package wisdom.core.connections;

import java.util.*;
import java.sql.*;
import java.io.*;
import java.net.URL;

import wisdom.core.CoreObject;
import wisdom.core.Log;
import wisdom.core.LogFactory;


/**
 * java.sql.PreparedStatement bvAPreparedStatementNXŎsꂽg[XNXB
 * 
 *
 * @author  Takao Kouda 
 * @version 0.90, 1/1/2001
 */
public class TracePreparedStatement extends CoreObject implements PreparedStatement {
	private Object invoker = null;
		
	private PreparedStatement stmt = null;
	private Log l = LogFactory.create();
	private TraceHelper th = TraceHelper.getInstance();
	private PrintWriter out = null;


	/**
	 * RXgN^
	 */	
	public TracePreparedStatement(Object invoker, PreparedStatement stmt) {
		super();
		this.invoker = invoker;		
		this.stmt = stmt;
		out = l.getWriter();		
	}
	
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param 		sql		ʏÓI SQL SELECT 
     * @return 				w肳ꂽNG[ɂč쐬ꂽf[^܂ ResultSet IuWFNgBnull ɂ͂ȂȂ
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public ResultSet executeQuery(String sql) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "executeQuery(sql)", sql));		
		out.flush();
		return stmt.executeQuery(sql);
	}

    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param 		sql		SQL INSERT AUPDATE A܂ DELETE A邢͉ԂȂ SQL 
     * @return 				INSERT AUPDATE ADELETE ̏ꍇ͍sBԂȂ SQL ̏ꍇ 0
     * @exception 			f[^x[XANZXG[ꍇ
     */      
	public int executeUpdate(String sql) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "executeUpdate(sql)", sql));
		out.flush();
		return stmt.executeUpdate(sql);
	}
 
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     * 
     * @exception 			f[^x[XANZXG[ꍇ
     */    
	public void close() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "close()"));
		out.flush();
		stmt.close();
	}
 
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     * 
     * @return 				݂̍ős̐lB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */   
	public int getMaxFieldSize() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "getMaxFieldSize()"));		
		out.flush();
		return stmt.getMaxFieldSize();
	}
 
 
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param 		max		VőTCY̐lB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */   
	public void setMaxFieldSize(int max) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setMaxFieldSize(max)", Integer.toString(max)));
		out.flush();
		stmt.setMaxFieldSize(max);
	}

    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     * 
     * @return 				݂̍ős̐lB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */ 
	public int getMaxRows() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "getMaxRows()"));
		out.flush();
		return stmt.getMaxRows();
	}
 
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     * @param 		max		Vős̐lB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */   
	public void setMaxRows(int max) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setMaxRows(max)", Integer.toString(max)));		
		out.flush();
		stmt.setMaxRows(max);
	}

    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     * @param 		enable	Lɂꍇ trueAɂꍇ false
     * @exception 			f[^x[XANZXG[ꍇ
     */            
	public void setEscapeProcessing(boolean enable) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setEscapeProcessing(enable)", new Boolean(enable).toString()));
		out.flush();
		stmt.setEscapeProcessing(enable);
	}

    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @return 				݂̃NG[^CAEg̐l̕bB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */    
	public int getQueryTimeout() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "getQueryTimeout()"));		
		out.flush();
		return stmt.getQueryTimeout();
	}
    
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     * 
     * @param 		seconds	VNG[^CAEg̐l̕bB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */            
	public void setQueryTimeout(int seconds) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setQueryTimeout(seconds)", Integer.toString(seconds)));
		out.flush();
		stmt.setQueryTimeout(seconds);
	}
    
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public void cancel() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "cancel()"));
		out.flush();
		stmt.cancel();
	}
    
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @return 				IuWFNg܂ null
     * @exception 			f[^x[XANZXG[ꍇ
     */    
	public SQLWarning getWarnings() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "getWarnings()"));		
		out.flush();
		return stmt.getWarnings();
	}
 
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public void clearWarnings() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "clearWarnings()"));		
		out.flush();
		stmt.clearWarnings();
	}
 
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     * 
     * @param 		name	VJ[\BڑňӂɂKv
     * @exception 			f[^x[XANZXG[ꍇ
     */   
	public void setCursorName(String name) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setCursorName(name)", name));
		out.flush();
		stmt.setCursorName(name);
	}
  
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     * @param 		sql		Cӂ SQL 
     * @return 				̌ʂ ResultSet IuWFNg̏ꍇ trueBXVJEgł邩A܂͌ʂȂꍇ false
     * @exception 			f[^x[XANZXG[ꍇ
     */  
	public boolean execute(String sql) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "execute(sql)", sql));		
		out.flush();
		return stmt.execute(sql);
	}
 
 
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @return 				ResultSet IuWFNgƂĂ݂̌̌ʁBXVJEgł邩A܂͌ʂȂꍇ null
     * @exception 			f[^x[XANZXG[ꍇ
     */       
	public ResultSet getResultSet() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "getResultSet()"));
		out.flush();
		return stmt.getResultSet();
	}
 
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @return 				XVJEgĂ݂̌̌ʁB݂̌ʂ ResultSet IuWFNgł邩A܂͌ʂȂꍇ -1
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public int getUpdateCount() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "getUpdateCount()"));		
		out.flush();
		return stmt.getUpdateCount();
	}
    
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @return 				̌ʂ ResultSet IuWFNg̏ꍇ trueBXVJEgł邩A܂͌ʂȂꍇ false
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public boolean getMoreResults() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "getMoreResults()"));
		out.flush();
		return stmt.getMoreResults();
	}
    
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param direction	s鏉
     * @exception 			f[^x[XANZXG[ꍇA܂͎w肳ꂽ ResultSet.FETCH_FORWARDAResultSet.FETCH_REVERSEA܂ ResultSet.FETCH_UNKNOWN ̂ǂłȂꍇ
     */     
	public void setFetchDirection(int direction) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setFetchDirection(direction)", Integer.toString(direction)));
		out.flush();
		stmt.setFetchDirection(direction);
	}
    
 
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @return 				 Statement IuWFNg琶ꂽʃZbg̃ftHg̃tFb`
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public int getFetchDirection() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "getFetchDirection()"));		
		out.flush();
		return stmt.getFetchDirection();
	}
    
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param 		rows	tFb`s 
     * @exception 			f[^x[XANZXG[ꍇA܂͏ 0 <= rows <= this.getMaxRows() Ȃꍇ
     */   
	public void setFetchSize(int rows) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setFetchSize(rows)", Integer.toString(rows)));				
		out.flush();
		stmt.setFetchSize(rows);
	}

    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @return 			 Statement IuWFNg琶ꂽʃZbg̃ftHg̃tFb`TCY
     * @exception 		f[^x[XANZXG[ꍇ
     */
	public int getFetchSize() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "getFetchSize()"));						
		out.flush();
		return stmt.getFetchSize();
	}

    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @return			ResultSet.CONCUR_READ_ONLY ܂ ResultSet.CONCUR_UPDATABLE
     */    
	public int getResultSetConcurrency() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "getResultSetConcurrency()"));		
		out.flush();
		return stmt.getResultSetConcurrency();
	}
    
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @return		 		ResultSet.TYPE_FORWARD_ONLYAResultSet.TYPE_SCROLL_INSENSITIVEA܂ ResultSet.TYPE_SCROLL_SENSITIVE ̂ 1 
     */    
	public int getResultSetType()  throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "getResultSetType()"));				
		out.flush();
		return stmt.getResultSetType();
	}
    
    /**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param 		sql 	ʏÓI SQL INSERT A܂ UPDATE 
     * @exception 			f[^x[XANZXG[ꍇA܂̓hCoob`T|[gĂȂꍇ
     */
	public void addBatch(String sql) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "addBatch(sql)", sql));
		out.flush();
		stmt.addBatch(sql);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
	 * 
	 * @exception  	f[^x[XANZXG[ꍇA܂̓hCoob`T|[gĂȂꍇ
	 */
	public void clearBatch() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "clearBatch()"));		
		out.flush();
		stmt.clearBatch();
	}

	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @return 				ob`̃R}hƂ 1 ̗vfi[ĂXVJEg̔zB
     *						z̗vf̓R}hob`ɒǉꂽŕׂB
     * @exception			f[^x[XANZXG[ꍇA܂̓hCoob`T|[gĂȂꍇ
     */
    public int[] executeBatch() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "executeBatch()"));				
		out.flush();
		return stmt.executeBatch();
	}

	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @return 				̕𐶐ڑ
     * @exception			f[^x[XANZXG[ꍇ
     */
	public Connection getConnection()  throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "getConnection()"));
		return stmt.getConnection(); 
	}
	
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @return					NG[ɂč쐬ꂽf[^܂ ResultSet IuWFNgBnull ɂ͂ȂȂ
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public ResultSet executeQuery() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "executeQuery()"));		
		out.flush();
		return new TraceResultSet(invoker, stmt.executeQuery());
	}
	
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public boolean execute() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "execute()"));
		out.flush();
		return stmt.execute();
	}

	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     * 
     * @return 					INSERT AUPDATE ADELETE ̏ꍇ͍sBԂȂ SQL ̏ꍇ 0
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public int executeUpdate() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "executeUpdate()"));		
		out.flush();		
		return stmt.executeUpdate();
	}
	
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void addBatch() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "addBatch()"));
		out.flush();
		stmt.addBatch();
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	sqlType			java.sql.Types Œ` SQL ^R[h
     * @exception				f[^x[XANZXG[ꍇ
     */
	public void setNull(int parameterIndex, int sqlType) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setNull(parameterIndex,sqlType)", parameterIndex + " " +sqlType));		
		out.flush();
		stmt.setNull(parameterIndex, sqlType);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setBoolean(int parameterIndex, boolean x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setBoolean(parameterIndex,x)", parameterIndex + " " +x));				
		out.flush();
		stmt.setBoolean(parameterIndex, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setByte(int parameterIndex, byte x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setByte(parameterIndex,x)", parameterIndex + " " +x));
		out.flush();
		stmt.setByte(parameterIndex, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setShort(int parameterIndex, short x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setShort(parameterIndex,x)", parameterIndex + " " +x));		
		out.flush();
		stmt.setShort(parameterIndex, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setInt(int parameterIndex, int x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setInt(parameterIndex,x)", parameterIndex + " " +x));
		out.flush();
		stmt.setInt(parameterIndex, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setLong(int parameterIndex, long x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setLong(parameterIndex,x)", parameterIndex + " " +x));		
		out.flush();
		stmt.setLong(parameterIndex, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setFloat(int parameterIndex, float x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setFloat(parameterIndex,x)", parameterIndex + " " +x));
		out.flush();
		stmt.setFloat(parameterIndex, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setDouble(int parameterIndex, double x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setDouble(parameterIndex,x)", parameterIndex + " " +x));
		out.flush();
		stmt.setDouble(parameterIndex, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setBigDecimal(int parameterIndex, java.math.BigDecimal x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setBigDecimal(parameterIndex,x)", parameterIndex + " " +x));
		out.flush();
		stmt.setBigDecimal(parameterIndex, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setString(int parameterIndex, String x) throws SQLException{
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setString(parameterIndex,x)", parameterIndex + " " +x));		
		out.flush();
		stmt.setString(parameterIndex, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setBytes(int parameterIndex, byte x[]) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setBytes(parameterIndex,x)", parameterIndex + " " +x));				
		out.flush();
		stmt.setBytes(parameterIndex, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setDate(int parameterIndex, java.sql.Date x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setDate(parameterIndex,x)", parameterIndex + " " +x));
		out.flush();
		stmt.setDate(parameterIndex, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setTime(int parameterIndex, java.sql.Time x)  throws SQLException {
		out.flush();
		stmt.setTime(parameterIndex, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setTimestamp(int parameterIndex, java.sql.Timestamp x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setTimestamp(parameterIndex,x)", parameterIndex + " " +x));		
		out.flush();
		stmt.setTimestamp(parameterIndex, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				ASCII p[^l܂ Java ̓Xg[
     * @param	length 			Xg[̃oCg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setAsciiStream(int parameterIndex, java.io.InputStream x, int length) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setAsciiStream(parameterIndex,x,lengh)", parameterIndex + " " +x+ " " + length));		
		out.flush();
		stmt.setAsciiStream(parameterIndex, x, length);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				UNICODE p[^l܂ Java ̓Xg[
     * @param	length 			Xg[̃oCg
     * @exception				f[^x[XANZXG[ꍇ
     */
	public void setUnicodeStream(int parameterIndex, java.io.InputStream x, int length) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setUnicodeStream(parameterIndex,x,lengh)", parameterIndex + " " +x+ " " + length));				
		out.flush();
		stmt.setUnicodeStream(parameterIndex, x, length);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				oCip[^l܂ Java ̓Xg[
     * @param	length 			Xg[̃oCg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setBinaryStream(int parameterIndex, java.io.InputStream x,  int length) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setBinaryStream(parameterIndex,x,lengh)", parameterIndex + " " +x+ " " + length));
		out.flush();
		stmt.setBinaryStream(parameterIndex, x, length);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void clearParameters() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "clearParameters()"));
		out.flush();
		stmt.clearParameters();
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				̓p[^l܂ރIuWFNg
     * @param	targetSqlType	f[^x[Xɑ (java.sql.Types Œ`) SQL ^BXP[ŁAɌ^ł
     * @param 	scale			java.sql.Types.DECIMAL  java.sql.Types.NUMERIC ^ł́A_ȉ̌Bقׂ̂Ă̌^ł́A̒l͖
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setObject(parameterIndex,x,targetSqlType,scale)", parameterIndex + " " + x +" "+ targetSqlType + " " + scale));
		out.flush();
		stmt.setObject(parameterIndex, x, targetSqlType, scale);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				̓p[^l܂ރIuWFNg
     * @param	targetSqlType	f[^x[Xɑ (java.sql.Types Œ`) SQL ^BXP[ŁAɌ^ł
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setObject(parameterIndex,x,targetSqlType,lengh)", parameterIndex + " " + x +" "+ targetSqlType));
		out.flush();
		stmt.setObject(parameterIndex, x, targetSqlType);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				̓p[^l܂ރIuWFNg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setObject(int parameterIndex, Object x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setObject(parameterIndex,x,targetSqlType,lengh)", parameterIndex + " " + x));		
		out.flush();
		stmt.setObject(parameterIndex, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	reader			UNICODE f[^܂ Java [_
     * @param	length			Xg[̕
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setCharacterStream(int parameterIndex, java.io.Reader reader, int length) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setCharacterStream(parameterIndex,reader,lengh)", parameterIndex + " " + reader +" "+ length));		
		out.flush();
		stmt.setCharacterStream(parameterIndex, reader, length);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	i				ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				SQL REF l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setRef(int i, Ref x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setRef(i, x)", i + " "+ x));		
		out.flush();
		stmt.setRef(i, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	i				ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				SQL BLOB l}bsO Blob IuWFNg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setBlob(int i, Blob x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setBlob(i, x)", i + " "+ x));				
		out.flush();
		stmt.setBlob(i, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	i				ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				SQL CLOB l}bsO Clob IuWFNg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setClob(int i, Clob x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setClob(i, x)", i + " "+ x));						
		out.flush();
		stmt.setClob(i, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	i				ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				SQL ARRAY l}bsO Array IuWFNg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setArray(int i, Array x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setArray(i, x)", i + " "+ x));
		out.flush();
		stmt.setArray(i, x);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @return 					IuWFNg̃J̋Lq
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public ResultSetMetaData getMetaData() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "getMetaData()"));		
		out.flush();
		return stmt.getMetaData();
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @param	cal				hCot쐬邽߂Ɏgp Calendar IuWFNg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setDate(int parameterIndex, java.sql.Date x, Calendar cal) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setDate(parameterIndex,x,cal)",parameterIndex+" "+x+" "+cal));
		out.flush();
		stmt.setDate(parameterIndex, x, cal);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @param	cal				hCot쐬邽߂Ɏgp Calendar IuWFNg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setTime(int parameterIndex, java.sql.Time x, Calendar cal) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setTime(parameterIndex,x,cal)",parameterIndex+" "+x+" "+cal));						
		out.flush();
		stmt.setTime(parameterIndex, x, cal);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @param	cal				hCot쐬邽߂Ɏgp Calendar IuWFNg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setTimestamp(int parameterIndex, java.sql.Timestamp x, Calendar cal) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setTimestamp(parameterIndex,x,cal)",parameterIndex+" "+x+" "+cal));						
		out.flush();
		stmt.setTimestamp(parameterIndex, x, cal);
	}
	/**
     * g[Xo͂APreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	sqlType			java.sql.Types ̒l
     * @param	typeName		SQL [U`^̊Sw̖OBp[^[U`^ł REF łȂꍇ͖
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setNull(paramIndex,sqlType,typeName)",parameterIndex+" "+sqlType+" "+typeName));						
		out.flush();
		stmt.setNull(parameterIndex, sqlType, typeName);
	}
	
	// java 1.6 
	public boolean getMoreResults(int current) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "getMoreResults(current)",current+""));
		out.flush();
		return stmt.getMoreResults(current);
	}
	public ResultSet getGeneratedKeys() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "getGeneratedKeys()"));
		out.flush();
		return stmt.getGeneratedKeys();
	}
	public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "executeUpdate(sql,autoGeneratedKeys)",sql+" "+autoGeneratedKeys));
		out.flush();
		return stmt.executeUpdate(sql, autoGeneratedKeys);
	}
	public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "executeUpdate(sql,columnIndexes)",sql+" "+columnIndexes));
		out.flush();
		return stmt.executeUpdate(sql, columnIndexes);
	}
	public int executeUpdate(String sql, String[] columnNames) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "executeUpdate(sql,columnNames)",sql+" "+columnNames));
		out.flush();
		return stmt.executeUpdate(sql, columnNames);
	}
	public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "execute(sql,autoGeneratedKeys)",sql+" "+autoGeneratedKeys));
		out.flush();
		return stmt.execute(sql, autoGeneratedKeys);
	}
	public boolean execute(String sql,  int[] columnIndexes) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "execute(sql,columnIndexes)",sql+" "+columnIndexes));
		out.flush();
		return stmt.execute(sql, columnIndexes);
	}
	public boolean execute(String sql, String[] columnNames) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "execute(sql,columnNames)",sql+" "+columnNames));
		out.flush();
		return stmt.execute(sql, columnNames);
	}
	public int getResultSetHoldability() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "getResultSetHoldability()"));
		out.flush();
		return stmt.getResultSetHoldability();
	}
	public void setPoolable(boolean poolable) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setPoolable(poolable)",""+poolable));
		out.flush();
		stmt.setPoolable(poolable);
	}
	public boolean isPoolable() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "isPoolable()"));
		out.flush();
		return stmt.isPoolable();
	}
	public boolean isClosed() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "isClosed()"));
		out.flush();
		return stmt.isClosed();
	} 	
	
	public void setURL(int parameterIndex, URL x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setURL(parameterIndex,x)",parameterIndex+" "+x));
		out.flush();
		stmt.setURL(parameterIndex, x);
	}

	public ParameterMetaData getParameterMetaData() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "getParameterMetaData()"));
		out.flush();
		return stmt.getParameterMetaData();
	}

	public void setRowId(int parameterIndex, RowId x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setRowId(parameterIndex,x)",parameterIndex+" "+x));
		out.flush();
		stmt.setRowId(parameterIndex, x);
	}

	public void setNString(int parameterIndex, String value) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setNString(parameterIndex,value)",parameterIndex+" "+value));
		out.flush();
		stmt.setNString(parameterIndex, value);
	}

	public void setNCharacterStream(int parameterIndex, Reader value,long length) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setNCharacterStream(parameterIndex,value,length)",parameterIndex+" "+value+" "+length));
		out.flush();
		stmt.setNCharacterStream(parameterIndex, value, length);
	}

	public void setNClob(int parameterIndex, NClob value) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setNClob(parameterIndex,value)",parameterIndex+" "+value));
		out.flush();
		stmt.setNClob(parameterIndex, value);
	}

	public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setClob(parameterIndex,reader,length)",parameterIndex+" "+reader+" "+length));
		out.flush();
		stmt.setClob(parameterIndex, reader, length);
	}

	public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setBlob(parameterIndex,inputStream,length)",parameterIndex+" "+inputStream+" "+length));
		out.flush();
		stmt.setBlob(parameterIndex, inputStream, length);
	}

	public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setNClob(parameterIndex,reader,length)",parameterIndex+" "+reader+" "+length));
		out.flush();
		stmt.setNClob(parameterIndex, reader, length);
	}

	public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setSQLXML(parameterIndex,xmlObject)",parameterIndex+" "+xmlObject));
		out.flush();
		stmt.setSQLXML(parameterIndex, xmlObject);
	}

	public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setAsciiStream(parameterIndex,x,length)",parameterIndex+" "+x+" "+length));
		out.flush();
		stmt.setAsciiStream(parameterIndex, x, length);
	}

	public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setBinaryStream(parameterIndex,x,length)",parameterIndex+" "+x+" "+length));
		out.flush();
		stmt.setBinaryStream(parameterIndex, x, length);
	}

	public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setCharacterStream(parameterIndex,reader,length)",parameterIndex+" "+reader+" "+length));
		out.flush();
		stmt.setCharacterStream(parameterIndex, reader, length);
	}

	public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setAsciiStream(parameterIndex,x)",parameterIndex+" "+x));
		out.flush();		
		stmt.setAsciiStream(parameterIndex, x);
	}

	public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setBinaryStream(parameterIndex,x)",parameterIndex+" "+x));
		out.flush();		
		stmt.setBinaryStream(parameterIndex, x);
	}

	public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setCharacterStream(parameterIndex,reader)",parameterIndex+" "+reader));
		out.flush();		
		stmt.setCharacterStream(parameterIndex, reader);
	}

	public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setNCharacterStream(parameterIndex,value)",parameterIndex+" "+value));
		out.flush();		
		stmt.setNCharacterStream(parameterIndex, value);
	}

	public void setClob(int parameterIndex, Reader reader) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setClob(parameterIndex,reader)",parameterIndex+" "+reader));
		out.flush();		
		stmt.setClob(parameterIndex, reader);
	}

	public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setBlob(parameterIndex,inputStream)",parameterIndex+" "+inputStream));
		out.flush();		
		stmt.setBlob(parameterIndex, inputStream);
	}

	public void setNClob(int parameterIndex, Reader reader) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "setNClob(parameterIndex,reader)",parameterIndex+" "+reader));
		out.flush();		
		stmt.setNClob(parameterIndex, reader);
	}
	
 
	// java.sql.Wrapper
	public boolean isWrapperFor(Class iface) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "isWrapperFor(iface)",iface+""));
		out.flush();
		return stmt.isWrapperFor(iface);
	}
	public Object  unwrap(Class iface) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.PREPARED_STATEMENT, "unwrap(iface)",iface+""));
		out.flush();
		return stmt.unwrap(iface);
	}
}
