package wisdom.core.request;

import java.io.*;
import java.util.*;

import wisdom.core.CoreObject;

public class MultiPartFormDataParser extends CoreObject {
	private String encoding = null;

	String contentType;
	String boundary;             //ex. -----------------------------7d1ab2d10286
	String lastBoundary;         //ex. -----------------------------7d1ab2d10286--
	byte   boundary_b[];         //byte image of boundary
	BufferedInputStream bis = null;
	
	public MultiPartFormDataParser(String contentType, InputStream is) throws UnsupportedEncodingException{
		this.contentType = contentType;
		boundary         = getBoundary(contentType);
		boundary_b       = boundary.getBytes();
		lastBoundary	 = boundary + "--";
		bis = new BufferedInputStream(is);
		encoding = configManager.getString(ParameterParser.REQUEST_PARAMETER_ENCODEING,null);
	}
	
	public List parse() throws Exception {
		ArrayList list = new ArrayList();
		VirtualOutputStream os = new VirtualOutputStream();
		while (true) {
			int idata = bis.read();
			if (idata == -1) break;
			os.write(idata);
		}
		os.close();
		PartMaker pm = new PartMaker(os.getOutput(), getBoundary(contentType));
		while(pm.hasNextBoundary()) { 
			byte[] boundaryBytes = pm.nextBoundary();
			if (boundaryBytes == null) break;
			Part part = new Part();
			list.add(part);
			part.addHeader(PartMaker.getHeader(boundaryBytes, 1));
			part.addHeader(PartMaker.getHeader(boundaryBytes, 2));
			part.setContent(PartMaker.getContents(boundaryBytes, part.getType(), encoding));
		}
		
		return list;

	}//parse

	public static String getBoundary(String contentType) {
		/* contentType multipart/form-data; boundary=---------------------------7d21c022303d4 `œ*/
		StringTokenizer st = new StringTokenizer(contentType, ";");
		String boundary = null;
		while (st.hasMoreTokens()) {
			String t = st.nextToken().trim();
			if (t.startsWith("boundary=")) {
				StringTokenizer st1 = new StringTokenizer(t, "=");
				st1.nextToken();
				boundary = st1.nextToken();
				break;
			}
		}
		/* ʂ -----------------------------7d21c022303d4	 */		
		/* 擾łboundaryϐ--Oɒǉ			*/
		if (boundary != null) boundary = "--"+boundary;
		return boundary;
	}
}
