package wisdom.core.request;

import java.util.*;

public class Part {
	
	public static final int INPUT=0;
	public static final int FILE=1;

	Vector headers = new Vector();
	int type=INPUT;  
	String name;
	String filename;
	String contentType;
	Object content;

	public Part() { super(); }
	public Part(String name,
				String filename,
				String contentType,
				Object content) {
		this();
		this.name = name;
		this.filename = filename;
		this.contentType = contentType;
		this.content = content;
		if ( filename != null ) type = FILE;
	}
	public void addHeader_modified2below20031030(String header) {
		if (header == null || header.length() == 0 ) return; 
		headers.add(header);

		StringTokenizer st = new StringTokenizer(header, ":");
		String tkn = st.nextToken().trim();
		if (tkn.equals("Content-Disposition")) {

			StringTokenizer st1 = new StringTokenizer(header.substring(header.indexOf(':')).trim(), ";");
			while (st1.hasMoreTokens()) {
				String tkn1 = st1.nextToken().trim();
				if (tkn1.startsWith("name=")) 
					name = tkn1.substring(6,tkn1.length()-1);
				else if (tkn1.startsWith("filename=")) {
					filename = tkn1.substring(10,tkn1.length()-1);
					type = FILE;
				}
			}
		} else if (tkn.equals("Content-Type")) {
			contentType = st.nextToken().trim();
		}
	}
	public void addHeader(String header) {
		if (header == null || header.length() == 0 ) return; 
		headers.add(header);

		StringTokenizer st = new StringTokenizer(header, ":");
		String tkn = st.nextToken().trim();
		if (tkn.equals("Content-Disposition")) {
			//StringTokenizer st1 = new StringTokenizer(header.substring(header.indexOf(':')).trim(), ";");
			
			String str = header.substring(header.indexOf(':')).trim();
			int fieldNameIndex = str.indexOf("form-data; name=\"");
			int fileNameIndex = str.indexOf("\"; filename=\"");			

			boolean isFile = (fileNameIndex != -1);
			if (isFile) {
				name = str.substring(fieldNameIndex+"form-data; name=\"".length(), fileNameIndex);				
				filename = str.substring(fileNameIndex+"\"; filename=\"".length(), str.length()-1);
				type = FILE;								
			} else {
				name = str.substring(fieldNameIndex+"form-data; name=\"".length(), str.length()-1);
			}
		} else if (tkn.equals("Content-Type")) {
			contentType = st.nextToken().trim();
		}
	}
	/**
	 * Part̃^CvԂ܂B
	 *
	 * @return     Part̃^Cv(Part.INPUT܂Part.FILE)
	 */
	public int getType() {
		return type;
	}

	/**
	 * PartɎw肳ꂽheaderԂ܂B
	 *
	 * @return     PartɎw肳ꂽheader
	 * @since      1.03
	 */
	public Vector getHeaders() {
		return headers;
	}

	/**
	 * HTMLtH[name=Ŏw肵OԂ܂B
	 *
	 * @return     HTMLtH[name=Ŏw肵O
	 * @since      1.03
	 */
	public String getName() {
		return name;
	}

	/**
	 * Abv[hEt@C̃t@CԂ܂Btype="FILE"̏ꍇ̂ݗLB
	 *
	 * @return     Abv[hEt@C̃t@C
	 */
	public String getFileName() {
		int s = filename.lastIndexOf('\\');
		return filename.substring(s + 1 , filename.length());		
//		return filename;
	}

	public void setContent(Object content) {
		this.content = content;
	}
	
	/**
	 * Part̃RecԂ܂B
	 *
	 * @return     type="INPUT"̏ꍇString<BR>
	 *             type="FILE"̏ꍇ̓Abv[hꂽt@C̃RecłbytezB
	 * @since      1.03
	 */
	public String getContentType() {
		return contentType;
	}
	/**
	 * Part̃RecԂ܂B
	 *
	 * @return     type="INPUT"̏ꍇString<BR>
	 *             type="FILE"̏ꍇ̓Abv[hꂽt@C̃RecłbytezB
	 */
	public Object getContent() {
		return content;
	}
	
	/**
	 * Part̃Rec̒Ԃ܂B
	 *
	 * @return     type="INPUT"̏ꍇString<BR>
	 *             type="FILE"̏ꍇ̓Abv[hꂽt@C̃RecłbytezB
	 */
	public int getContentLength() {
		if (content==null) return 0;
		if (type == INPUT) return content.toString().length();
		else {
			byte[] data = (byte[])content;
			return data.length;
		}
	}
		
	public String toString() {
		StringBuffer sb = new StringBuffer(getClass().getName());
		if ( type == INPUT) sb.append(" <INPUT> ");
		else sb.append(" <FILE> ");
		sb.append("name=");
		if (name != null) sb.append(name);
		else sb.append("null");
		sb.append(" filename=");
		if (filename!=null) sb.append(filename);
		else sb.append("null");
		sb.append(" contentType=");
		if (contentType != null) sb.append(contentType);
		else sb.append("null");
		sb.append(" content=");
		if ( type == INPUT) {
			if (content != null) sb.append(content.toString());
			else sb.append("null");
		} else {
			if (content != null) sb.append(content.getClass().getName());
			else sb.append("null");
		}
		sb.append(" contentLength=");
		sb.append(getContentLength());
		return sb.toString();
	}
}
