package wisdom.core.request;

import java.io.*;

/**
 * 
 */
public class PartMaker  {

	private byte[] buffer = null;
	private int fromIndex = 0;

	private String boundary = null;
	private String lastBoundary = null;	
	
	private byte[] boundaryBytes = null;
	private byte[] lastBoundaryBytes = null;
	private int boundaryLen = 0;	
	private int lastBoundaryLen = 0;		
	
	private boolean EOF = false;

	private static final String CR_ = "\r";
	private static final String LF_ = "\n";	
	private static final String CRLF_ = "\r\n";
	
	private static final String BOUNDARY_LAST = "--";
	
	private static final byte CR = CR_.getBytes()[0];	
	private static final byte LF = LF_.getBytes()[0];	

	/**
	 * RXgN^
	 *
	 * @param buffer 	͂oCgz
	 * @param boundary 	؂̔ʂɎgpBoundaryB
	 */
	PartMaker(byte[] buffer, String boundary) {
		this.buffer = buffer;
		this.boundary = boundary;
		lastBoundary = boundary + BOUNDARY_LAST;	
			
		boundary = boundary + CRLF_;
		lastBoundary = lastBoundary + CRLF_;
		
		boundaryBytes = boundary.getBytes();
		lastBoundaryBytes = lastBoundary.getBytes();
		
		boundaryLen = boundaryBytes.length;
		lastBoundaryLen = lastBoundaryBytes.length;
	}

	/**
	 * ̃IuWFNgoCgzɎ boundaryf[^܂܂邩ׂB
	 *
	 * @return boolean 	boundaryf[^ꍇtrueB
	 */
	public boolean hasNextBoundary() throws IOException {
		if (EOF) return false;
		VirtualOutputStream line = new VirtualOutputStream();

		for (int i = fromIndex ; i < buffer.length ; i++) {
			line.write((int)buffer[i]);			
			if (buffer[i] == LF) {
				line.close();
				switch (isBoundary(line.getOutput())) {
						case(1) :	fromIndex = i + 1;
									return true;
						case(0) :	break;	
						case(-1):	return false;
				}
				line = new VirtualOutputStream();				
			} 
		}
		EOF = true;
		return EOF;
	}
	
	/**
	 * Ɏ擾łboundary܂܂oCgz擾B
	 * 擾łȂꍇ null ԂB
	 * 
	 * @return byte[]  boundary܂܂oCgz
	 */
	public byte[] nextBoundary() throws IOException {
		if (EOF) return null;
		VirtualOutputStream data = new VirtualOutputStream();
		VirtualOutputStream line = new VirtualOutputStream();	

		for (int i = fromIndex ; i < buffer.length ; i++) {
			data.write((int)buffer[i]);
			line.write((int)buffer[i]);				
			if (buffer[i] == LF) {
				line.close();
				byte[] lineByte = line.getOutput();
				switch (isBoundary(lineByte)) {
						case(1) :	fromIndex = i - boundaryLen + 1;
									data.close();
									return cutBoundary(data.getOutput(), boundaryLen);
						case(-1) :  data.close();
									return cutBoundary(data.getOutput() , lastBoundaryLen);
						case(0)	 :  line = new VirtualOutputStream(); break;
				}
			} 
		}
		line.close();
		data.close();
		return cutBoundary(data.getOutput(),lastBoundaryLen);
	}
	
	/**
	 * boundary܂܂oCgz񂩂wb_[i1sA2sځjStringƂĎ擾B
	 * 
	 * ł̃oCgz
	 *
	 *		Content-Disposition: form-data; name="mailaddress"
	 *
	 *		PDf2
	 * ƂȂĂB
	 *
	 * @param byteArray 	boundary܂܂oCgz
	 * @param lineNumber 	1sڂ2sڂ̎w
	 * @return String 		wb_[
	 */
	protected static String getHeader(byte[] byteArray, int lineNumber) throws IOException {
		VirtualOutputStream temp = new VirtualOutputStream();
		int count = 1;
		for (int i = 0 ; i < byteArray.length; i++) {
			if (byteArray[i] == LF) count++;
			if (count > lineNumber) break;			
			if ((count == lineNumber) && (byteArray[i] != CR) && (byteArray[i] != LF)) 
					temp.write((int)byteArray[i]);
		}
		temp.close();
		return new String(temp.getOutput());
	}
	
	/**
	 * boundary܂܂oCgz񂩂RecObjectƂĎ擾B
	 * 
	 * ł̃oCgz
	 *
	 *		Content-Disposition: form-data; name="mailaddress"
	 *
	 *		PDf2
	 * ƂȂĂB
	 *
	 * @param byteArray 	boundary܂܂oCgzB
	 * @param type 			boundary̎ʁBPart.INPUTAPart.FILEŎw肷B
	 * @param encoding     encoding̎.
	 * @return Object 		boundaryINPUT̏ꍇ̓eLXg܂StringBFILȄꍇ̓oCgz܂ObjectB
	 */
	protected static Object getContents(byte[] byteArray, int type, String encoding) throws IOException {
		/* ^CvINPUT̏ꍇ3sځAFILȄꍇ4sڂ*/		
		int lineNumber = type + 3;

		int count = 1;		
		int index = 0;

		while(index < byteArray.length) {
			if (byteArray[index] == LF) count++;	/* s */
			index++;
			if (count == lineNumber) break;			/* ړI̍sɒBꍇAindex++Ă̂*/
		}
		
		int contentsLen = byteArray.length - index;	
		byte[] data = new byte[contentsLen];
		System.arraycopy(byteArray, index , data, 0, contentsLen);
		if (type == Part.INPUT) {
			if (encoding == null) {
				return new String(data);	
			} else {
				return new String(data,encoding);
			}
			
		} 
		else return data;
	}
	/**
	 * ̃oCgz񂩂boundary̒AэŌCR,LFoCgzԂ
	 * ł̃oCgz
	 *
	 *		Content-Disposition: form-data; name="mailaddress"
	 *
	 *		PDf2
	 *		-----------------------------7d2bb232805ac
	 *
	 * ƂȂĂ̂	CR,LF-----------------------------7d2bb232805ac	A
	 *		Content-Disposition: form-data; name="mailaddress"
	 *
	 *		PDf2
	 * ̃oCgzԂB
	 * 
	 * @param data CR,LFz
	 * @param boudaryLen boundary̒
	 */
	private byte[] cutBoundary(byte[] data, int cutBoundaryLen) {
		int copylen = data.length - cutBoundaryLen - 2;
		byte[] cutBoundaryByte = new byte[copylen];
		System.arraycopy(data, 0 , cutBoundaryByte , 0, copylen);
		return cutBoundaryByte;
	}	
	
	/**
	 * oCgz BoundaryLastBoundaryׂB
	 *
	 * @param comp roCgz
	 * @return int  1=boundaryƓA-1=last boundaryƓA0=boudaryAlast boundaryƂvȂ
	 */
	private int isBoundary(byte[] comp) {
		if (isSameBytes(boundaryBytes,comp)) return 1;				/* boundaryƓ */
		else if (isSameBytes(lastBoundaryBytes,comp)) {				/* lastboundaryƓ */		
			EOF = true;
			return -1;
		} else return 0;
	}
	/**
	 * ̃oCgz񂪓̔zeׂB
	 *
	 * @param source roCgz1
	 * @param comp roCgz2
	 * @return boolean true=Afalse=Ⴄ
	 */
	private boolean isSameBytes(byte[] source, byte[] comp) {
		if (source.length != comp.length) return false;
		int len = source.length;
		for (int i = 0 ; i < len ; i++ ) {
			if (source[i] != comp[i]) return false;
		}
		return true;
	}
}
