package wisdom.core.runtime;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.Map;
import java.util.Hashtable;
import java.util.Collection;
import java.sql.Connection;
import java.sql.SQLException;

import javax.servlet.ServletContext;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import wisdom.core.CoreMessageGenerator;
import wisdom.core.CoreObject;
import wisdom.core.MessageGenerator;
import wisdom.core.ServletRuntimeConfig;
import wisdom.core.application.IRequestCommand;
import wisdom.core.application.IRequestHandler;
import wisdom.core.application.IRequestParser;
import wisdom.core.application.IUserSession;
import wisdom.core.command.CommandSet;
import wisdom.core.command.MissConfiguredException;
import wisdom.core.command.RequestCommand;
import wisdom.core.connections.ConnectionDef;
import wisdom.core.connections.ConnectionManager;
import wisdom.core.connections.ConnectionManagerFactory;
import wisdom.core.request.MultiPartParameterParser;
import wisdom.core.request.ParameterParser;
import wisdom.core.session.MissingSessionObjectException;
import wisdom.core.session.SessionTimeOutedException;
import wisdom.core.util.StringUtil;

/**
 * IRequestHandler̎NX<br>
 * 
 * @author  Takao Kouda
 * @version 0.90, 1/1/2001
 *
 */
public class RequestHandler extends CoreObject implements IRequestHandler  {
	
	/** fĂ邩ǂ̃tOB 2dTu~bgpɎgp܂B */
	protected boolean suspend = false;

	/** ReueqstHandleȑLZǂ̃tOB 2dTu~bgpɎgp܂B*/
	protected boolean cancel = false;
	
	/** ReueqstHandleȑIǂ̃tOB 2dTu~bgpɎgp܂B */
	protected boolean finished = false;	

	protected List preDuplicateRequestHandler = null;
	
	private static final String contentMulti = "multipart/form-data";
		
	protected HttpServletRequest req 	= null;
	protected HttpServletResponse res 	= null;
	private   HttpSession session 		= null;
	protected IRequestParser pp 		= null;
	protected ConnectionManager conm 	= null;
	protected Object invoker 			= null;
	protected ServletConfig servletconfig = null;
	
	protected String reqid 			= null;

	private String user 				= null;
	private String password 			= null;
	
	private Map connections = new Hashtable();

	private boolean enterUserId = false;


	public RequestHandler(HttpServletRequest req, HttpServletResponse res, ServletConfig servletconfig) throws Exception {
		super();
		this.req = req;
		this.res = res;
		this.servletconfig = servletconfig;
		this.pp = generateRequestParser(req);
	}

	public void setAttribute(String key, Object value) {
		req.setAttribute(key, value);
	} 

	public Object getAttribute(String key) {
		return req.getAttribute(key);
	} 

	public HttpServletRequest getRequest() {
		return req;
	}

	public HttpServletResponse getResponse() {
		return res;
	}

	public IRequestParser getRequestParser() {
		return pp;
	}

	public ServletConfig getServletConfig() {
		return servletconfig;
	}

	public ServletContext getServletContext() {
		return servletconfig.getServletContext();
	}

	public String getUser() {
		return user;
	}	

	public Connection getConnection(String defineName) throws Exception {
		Connection c_ = (Connection)connections.get(defineName);
		if (c_ == null) {
			ConnectionDef def = configManager.getConnectionDef(defineName);
			ConnectionManager cmgr = ConnectionManagerFactory.create(def);
			c_ = cmgr.getConnection(invoker);
			connections.put(def.getDefineName(),c_);
		}
		return c_;
	}

	public Connection getConnection(String defineName, String user, String password) throws Exception {
		Connection c_ = (Connection)connections.get(defineName);
		if (c_ == null) {
			ConnectionDef def = configManager.getConnectionDef(defineName);
			ConnectionManager cmgr = ConnectionManagerFactory.create(def);
			c_ = cmgr.getConnection(invoker, user, password);
			connections.put(def.getDefineName(),c_);
		}
		return c_;
	}


	public Connection getConnection() throws Exception {
		ConnectionDef def = configManager.getConnectionDef();
		Connection c_ = (Connection)connections.get(def.getDefineName());
		if (c_ == null) {
			ConnectionManager cmgr = ConnectionManagerFactory.create(def);
			c_ = cmgr.getConnection(invoker);
			connections.put(def.getDefineName(),c_);
		}
		return c_;
	}	

	public Connection getConnection(String user, String password) throws Exception {
		ConnectionDef def = configManager.getConnectionDef();
		Connection c_ = (Connection)connections.get(def.getDefineName());
		if (c_ == null) {
			ConnectionManager cmgr = ConnectionManagerFactory.create(def);
			c_ = cmgr.getConnection(invoker, user, password);
			connections.put(def.getDefineName(),c_);
		}
		return c_;
	}	

	public Connection getConnection(Object invoker) throws Exception {
		ConnectionDef def = configManager.getConnectionDef();
		Connection c_ = (Connection)connections.get(def.getDefineName());
		if (c_ == null) {
			ConnectionManager cmgr = ConnectionManagerFactory.create(def);
			c_ = cmgr.getConnection(invoker);
			connections.put(def.getDefineName(),c_);
		}
		return c_;
	}	
	
	public Connection getConnection(Object invoker, String user, String password) throws Exception {
		ConnectionDef def = configManager.getConnectionDef();
		Connection c_ = (Connection)connections.get(def.getDefineName());
		if (c_ == null) {
			ConnectionManager cmgr = ConnectionManagerFactory.create(def);
			c_ = cmgr.getConnection(invoker, user, password);
			connections.put(def.getDefineName(),c_);
		}
		return c_;
	}
		
	public Connection getConnection(Object invoker, String defineName) throws Exception {
		Connection c_ = (Connection)connections.get(defineName);
		if (c_ == null) {
			ConnectionDef def = configManager.getConnectionDef(defineName);
			ConnectionManager cmgr = ConnectionManagerFactory.create(def);
			c_ = cmgr.getConnection(invoker);
			connections.put(def.getDefineName(),c_);
		}
		return c_;
	}	

	public Connection getConnection(Object invoker, String defineName, String user, String password) throws Exception {
		Connection c_ = (Connection)connections.get(defineName);
		if (c_ == null) {
			ConnectionDef def = configManager.getConnectionDef(defineName);
			ConnectionManager cmgr = ConnectionManagerFactory.create(def);
			c_ = cmgr.getConnection(invoker, user, password);
			connections.put(def.getDefineName(),c_);
		}
		return c_;
	}
	
	protected void commitAllConnections() {
		for (Iterator i = connections.values().iterator() ; i != null && i.hasNext();) {
			Connection c = (Connection)i.next();
			boolean isClosed = false;
			try {
				isClosed = c.isClosed();
			} catch (SQLException e) {}
			
			if (c == null || isClosed) continue;
			//if (c == null) continue;
			try {
				c.commit();
			} catch (Exception e) {}
		}		
	}
	protected void closeAllConnections() {
		for (Iterator i = connections.values().iterator() ; i != null && i.hasNext();) {
			Connection c = (Connection)i.next();
			boolean isClosed = false;
			try {
				isClosed = c.isClosed();
			} catch (SQLException e) {}
			
			if (c == null || isClosed) continue;
			//if (c == null) continue;			
			try {
				c.close();
			} catch (Exception e) {}
		}		
	}	
	protected void rollBackAllConnections() {
		for (Iterator i = connections.values().iterator() ; i != null && i.hasNext();) {
			Connection c = (Connection)i.next();
			boolean isClosed = false;
			try {
				isClosed = c.isClosed();
			} catch (SQLException e) {}
			
			if (c == null || isClosed) continue;
			//if (c == null) continue;			
			try {
				c.rollback();
			} catch (Exception e) {}
		}		
	}

	public void closeConnection(Connection c) throws Exception {
		for (Iterator i = connections.values().iterator() ; i != null && i.hasNext();) {
			Connection c_ = (Connection)i.next();
			boolean isClosed = false;
			try {
				isClosed = c_.isClosed();
			} catch (SQLException e) {}
			
			if (c_ == null || isClosed) continue;
			c_.commit();
			c_.close();
			connections.values().remove(c_);		
		}		
	}
	/**
	 * ̃\bhRequestHandlerł͎Ă܂B<br>
	 * sUnsupportedOperationExceptiono܂B<br>
	 */
	public IUserSession getUserSession() {
		throwException("getUserSession()");
		return null;
	}
	
	/**
	 * ̃\bhRequestHandlerł͎Ă܂B<br>
	 * sUnsupportedOperationExceptiono܂B<br>
	 */
	public void setSessionAttribute(String key, Object object) {
		throwException("setSessionAttribute");
	}

	/**
	 * ̃\bhRequestHandlerł͎Ă܂B<br>
	 * sUnsupportedOperationExceptiono܂B<br>
	 * @param key IuWFNg̃L[
	 */
	public void removeSessionAttribute(String key) {
		throwException("removeSessionAttribute");
	}

	/**
	 * ̃\bhRequestHandlerł͎Ă܂B<br>
	 * sUnsupportedOperationExceptiono܂B<br>
	 */
	public Object getSessionAttribute(String key) throws MissingSessionObjectException {
		throwException("getSessionAttribute");		
		return null;
	}
	
	/**
	 * ̃\bhRequestHandlerł͎Ă܂B<br>
	 * sUnsupportedOperationExceptiono܂B<br>
	 */
	public Object getSessionAttribute(String key, boolean allowNull) throws MissingSessionObjectException {
		throwException("getSessionAttribute");
		return null;						
	}
	/**
	 * ̃\bhRequestHandlerł͎Ă܂B<br>
	 * sUnsupportedOperationExceptiono܂B<br>
	 */
	public void cleanupRemovableSessionAttributes(){ 
		throwException("cleanupRemovableSessionAttribute");		
	}
	
	/**
	 * ̃\bhRequestHandlerł͎Ă܂B<br>
	 * sUnsupportedOperationExceptiono܂B<br>
	 */
	public void addUnremovableSessionAttributeName(String key) {
		throwException("addUnremovableSessionAttributeName");				
	}

	/**
	 * ̃\bhRequestHandlerł͎Ă܂B<br>
	 * sUnsupportedOperationExceptiono܂B<br>
	 */
	public void addUnremovableSessionAttributeNames(String[] keys) {
		throwException("addUnremovableSessionAttributeNames");		
	}
	
	/**
	 * ̃\bhRequestHandlerł͎Ă܂B<br>
	 * sUnsupportedOperationExceptiono܂B<br>
	 */
	public void removeUnremovableSessionAttributeName(String key){ 
		throwException("removeUnremovableSessionAttributeName");				
	}
	
	/**
	 * ̃\bhRequestHandlerł͎Ă܂B<br>
	 * sUnsupportedOperationExceptiono܂B<br>
 	 */
	public List getUnremovableSessionAttributeNames() {
		throwException("getUnremovableSessionAttributeNames");
		return null;				
	}
	private void throwException(String methodName) {
		throw new UnsupportedOperationException(
			messageGenerator.getMessage(
			"WSE0100", new String[] {getClass().getName(),"removeUnremovableSessionAttributeName"}).toString());
	}
	
	/**
	 * ZbVHttpSessionIuWFNgput܂B
	 */
	public void sessionStateChange(String page) throws Exception {
	}
	

	public String getReqId() {
		return reqid;
	}
	/** 
	 * ̃NXێĂHttpServletRequest ͂ėvɂCommand IuWFNg擾܂B
	 * ł ĂяoURIAHttpServletRequest ̒ "reqid" Ƃp[^CommandSet IuWFNg
	 * Command IuWFNg擾܂B
	 * HttpServletRequest̒"reqid"Ƃp[^Ȃꍇ́AURÎ݂gpĎ擾܂B
	 * 
	 * @return Command sCommandIuWFNg̃CX^XB
	 * @exception MissConfiguredException URIAURIreqidōvCommand݂Ȃꍇɑo܂B
	 */ 	
	public RequestCommand getCommand(CommandSet cs, ServletRuntimeConfig serlvetRuntimeConfig) throws Exception, MissConfiguredException {
		String servletPath = req.getServletPath();
		String uri = null;
		if ( servletPath.startsWith("/wtc") ) uri = "/" + servletPath.substring(4);
		else uri = servletPath;

		if (serlvetRuntimeConfig.getReqidName() == null) {
			reqid = pp.getString("reqid","");
		} else {
			reqid = pp.getString(serlvetRuntimeConfig.getReqidName(),"");
		}

		// 2008/5/16 ȗReqidΉ
		if (StringUtil.isEmpty(reqid) && StringUtil.notEmpty(serlvetRuntimeConfig.getDefaultReqid())) {
			reqid = serlvetRuntimeConfig.getDefaultReqid();
			trace("reqid is missing. executing use default reqid " + reqid);
		}
		if (StringUtil.isEmpty(reqid)) throw new ReqidNotFoundException();

		RequestCommand cmd = null;
		((ParameterParser)pp).setReqId(reqid);

		String cmdName = cs.getCommandName(reqid);

		try {
			cmd = (RequestCommand)Class.forName(cmdName).newInstance();
			this.invoker = cmd;
						
		} catch (Exception e) {
			debug(uri + " | " + reqid + " | " + cmdName + " | " + e.getMessage());
			String msg = e.getMessage();
			if (msg == null) msg = e.getClass().getName();
			
			if (cmdName == null) {
				throw new MissConfiguredException(messageGenerator.getMessage("WCE0020", new String[] {reqid}));				
			} else {
				throw new MissConfiguredException(messageGenerator.getMessage("WCE0030", new String[] {reqid, cmdName, msg}));				

			}
		}
		return cmd;
	}
	/**
	 * IuWFNg̏Ԃ`FbN郁\bhłB
	 * ̃\bhRequestHanlderł͏ȂĂ܂BSSHRHandler͎Ă܂B
	 * @exception		SessionTimeOutedException
	 * 
	 */
	protected void sessionCheck() throws SessionTimeOutedException { }	
	


	public IRequestCommand getInvoker() {
		return (IRequestCommand)invoker;
	}
	
	/**
	 * ̃R}h𒆒f܂B
	 * <b>̃\bh2dTu~bg邽߂ɎgpĂ郁\bhłBʏ̃AvP[Vł͎gpȂłB</b>
	 * <b>RequestHandlerNXł͂̃\bh͎Ă܂BTuNXłSSHRHander݂̂Ă܂</b>
	 * 
	 */
	protected void suspend() throws Exception {}
	
	/**
	 * ̃R}h𒆒f܂B
	 * <b>̃\bh2dTu~bg邽߂ɎgpĂ郁\bhłBʏ̃AvP[Vł͎gpȂłB</b>
	 * <b>RequestHandlerNXł͂̃\bh͎Ă܂BTuNXłSSHRHander݂̂Ă܂</b>
	 * 
	 */
	protected void finish() { }	
		
	private IRequestParser generateRequestParser(HttpServletRequest req) throws Exception {
		/* MultiPartۂ */
		String contentType = req.getContentType();
		if ((contentType != null) && 
				(contentType.startsWith(contentMulti)) && 
					req.getMethod().toUpperCase().equals("POST")) {
			return new MultiPartParameterParser(req);
			
		} else return new ParameterParser(req);
	}
	
	/**
	 * Gets the enterUserId
	 * @return Returns a boolean
	 */
	public boolean isEnterUserId() {
		return enterUserId;
	}
	/**
	 * Sets the enterUserId
	 * @param enterUserId The enterUserId to set
	 */
	public void setEnterUserId(boolean enterUserId) {
		this.enterUserId = enterUserId;
	}
}