package wisdom.core.runtime;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.Map;
import java.util.Hashtable;
import java.util.Collection;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;

import javax.servlet.ServletContext;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import wisdom.core.CoreObject;
import wisdom.core.application.IResponseDownLoader;



/**
 * IResponseDownLoader̎NX<br>
 * 
 * @author  Takao Kouda
 * @version 1
 *
 */
public class ResponseDownLoader extends CoreObject implements IResponseDownLoader {
	private HttpServletResponse res = null;
	private PrintWriter out = null;
	
	public ResponseDownLoader(HttpServletResponse res) {
		this.res = res;
	}
	
	public PrintWriter getWriter() throws Exception{
		if (out == null ) out = res.getWriter();
		return out;
	}

	public void write(byte[] buffer) throws Exception {
		if (buffer == null) return;
		ByteArrayInputStream bis = new ByteArrayInputStream(buffer);
		BufferedOutputStream bos = new BufferedOutputStream(res.getOutputStream());
		int l;
		byte buff[] = new byte[4096];
		l = bis.read(buff, 0 , buff.length);
		while (l != -1) {
			bos.write(buff, 0 , l);
			l = bis.read(buff,0,buff.length);
		}
		bos.flush();
		bis.close();		
	}
	public void setDownLoadFileName(String fileName) throws Exception {
		String fileName_ = new String(fileName.getBytes("Shift_JIS"), "ISO8859_1");
		res.setHeader("Content-Disposition","filename="+fileName_);		
	}

	protected boolean isGetWriter() {
		return out != null;
	}	
	public void setContentType(String contentType) {
		res.setContentType(contentType);		
	}

}