package wisdom.core.session;

import java.util.*;
import java.io.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;

import wisdom.core.ConfigManager;
import wisdom.core.CoreObject;
import wisdom.core.application.IUserSession;
import wisdom.core.runtime.ProcessController;


/**
 * {@link IUserSession }̎NXłB<br>
 *
 * @author  Takao Kouda
 * @version 1
 *
 */
public class UserSession extends CoreObject implements IUserSession,  Serializable, HttpSessionBindingListener {
	protected String userid = null;
	protected String name = null;
	protected Hashtable userObject;
	private HttpSession session = null;

	private String[] pageHistory = new String[]{"","",""};
	private String[] reqidHistory = new String[]{"","",""};	

	private boolean verboseEvent = false;

	private boolean authenticated = false;
	private List unremovableSessionNames = null;
	
	private UserSession() {
		super();
		unremovableSessionNames = new Vector();
		/* ProcessController.͏s  */ 
		unremovableSessionNames.add(ProcessController.class.getName());	
		userObject = new Hashtable();
		try {
			verboseEvent = new Boolean(configManager.getString(ConfigManager.VERBOSE_SESSION_EVENT,"false")).booleanValue();
		} catch (Exception e) {}
	}	
	/**
	 * RXgN^<br>
	 * [U[͖F؃[U[ƂăZbVێ܂B
	 * @param	session
	 */
	protected UserSession(HttpSession session) {
		this();
		this.session = session;
		trace("Constructor","User Anonymous logged on");		
	}

	/**
	 * RXgN^<br>
	 * [U[͔F؍ς݃[U[ƂăZbVێ܂B
	 * @param 	userid [U[ID
	 * @param	session HttpSession
	 */
	protected UserSession(HttpSession session, String userid) {
		this();
		trace("Constructor","User " + userid + " logged on");		
		this.session = session;		
		this.userid = userid;
		this.authenticated = true;

	}

	public String getUserid() { 
		return userid; 
	}
	
	public String getName() { 
		return name; 
	}
		
	public void setAttribute(String key, Object object) {
		removeAttribute(key);
		userObject.put(key, object);
	}
	
	public void removeAttribute(String key) {
		try {
			Object o = userObject.remove(key);
			o = null;
		} catch (NullPointerException npe) {} // Nothing to do	
	}	

	public Object getAttribute(String key) throws MissingSessionObjectException {
		Object o = userObject.get(key);
		if (o == null) {
			throw new MissingSessionObjectException(messageGenerator.getMessage("WSE0010",key));		
		}
		return o;
	}

	public Object getAttribute(String key, boolean allowNull) throws MissingSessionObjectException {
		Object o = userObject.get(key);
		if (o == null && !allowNull) {
			throw new MissingSessionObjectException(messageGenerator.getMessage("WSE0010",key));		
		}
		return o;
	}
		
	public Iterator getAttributeNames() {
		return userObject.keySet().iterator();
	}

	public void setRecentPage(String page) {
		for (int i = pageHistory.length ; i > 1 ; i--) {
			pageHistory[i-1] = pageHistory[i-2];
		}
		pageHistory[0] = page;
	}

	public void setRecentReqid(String reqid) {
		for (int i = reqidHistory.length ; i > 1 ; i--) {
			reqidHistory[i-1] = reqidHistory[i-2];
		}
		reqidHistory[0] = reqid;
	}
	
	public String getPageHistory(int historyNo) {
		if (historyNo < pageHistory.length) return pageHistory[historyNo];
		return "";
	}
	
	public String getReqidHistory(int historyNo) {
		if (historyNo < reqidHistory.length) return reqidHistory[historyNo];
		return "";
	}		

	public List getRecentPages() {
		List list = new Vector();
		for (int i = 0 ; i < pageHistory.length; i++) {
			list.add(pageHistory[i]);
		}
		return list;
	}	

	public List getRecentReqids() {
		List list = new Vector();
		for (int i = 0 ; i < reqidHistory.length; i++) {
			list.add(reqidHistory[i]);
		}
		return list;
	}		

	public HttpSession getHttpSession() {
		return session;
	}

	public void cleanupRemovableSessionAttributes() {
		synchronized (this) {
			Hashtable userObject_ = new Hashtable();
			for(Iterator i = userObject.keySet().iterator() ; i.hasNext() ;) {
				String key = (String)i.next();
				if (unremovableSessionNames.contains(key)) {
					userObject_.put(key,userObject.get(key));
				} 
			}
			userObject = userObject_;
		}		
	}
	
	public void addUnremovableSessionAttributeName(String key) {
		if (!unremovableSessionNames.contains(key)) unremovableSessionNames.add(key);
	}
	
	public void addUnremovableSessionAttributeNames(String[] keys) {
		if (keys == null) return;
		for (int i = 0 ; i < keys.length ; i++) {
			addUnremovableSessionAttributeName(keys[i]);
		}
	}	
	
	public void removeUnremovableSessionAttributeName(String key) {
		if (unremovableSessionNames.contains(key)) unremovableSessionNames.remove(key);
	}
	

	public List getUnremovableSessionAttributeNames() {
		return unremovableSessionNames;
	}	

	public void logOut() {
		session.invalidate();
		if (userid != null)	trace("logOut","User " + userid + " logged out");
		else trace("logOut","User logged out");
	}

	public void valueBound(HttpSessionBindingEvent event)  {
		if (verboseEvent) trace("valueBound", event.getName() + "=" + event.getValue());
	}		

	public  void valueUnbound(HttpSessionBindingEvent event) {
		if (verboseEvent) trace("valueUnbound", event.getName() + "=" + event.getValue());
	}
 	
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(getClass().getName()).append(".toString() userid=").append(userid).append("\n");
		boolean isFirst = true;
		for(Iterator i = userObject.keySet().iterator() ; i.hasNext() ;) {
			String key = (String)i.next();
			if (!isFirst) {
				sb.append(",");
			}
			sb.append("key=").append(key).append(", value=").append(userObject.get(key));
			if (isFirst) {
				isFirst = false;
			}
		}
		return sb.toString();
	}
	public boolean isAuthenticated() {
		return authenticated;
	}

}