package wisdom.core.session;


import java.sql.*;
import java.util.List;
import java.util.Vector;

import javax.servlet.http.*;

import wisdom.core.application.IRequestHandler;
import wisdom.core.application.ISessionCreateListener;
import wisdom.core.application.IUserSession;


/**
 * UserNX𐶐FactoryNXB
 * ̃NẌRequestHandleruseridłBœnuserid͂łɔF؂Ă܂B
 * 
 *
 * @author  Takao Kouda
 * @version 0.90, 1/1/2001
 *
 */
public class UserSessionFactory {
	private static UserSessionFactory factory = new UserSessionFactory();
	private static List listeners = new Vector();
	
	private UserSessionFactory() { 
		super();
	}
	
	/**
	 * IUserSession쐬ꂽƂɃCxgʒm{@link ISessionCreateListener}
	 * o^܂B<br>
	 * 
	 * @param listener
	 * @since 2004/5/6 Takao Kouda
	 */
	public static void addSessionCreateListener(ISessionCreateListener listener) {
		if (!listeners.contains(listener)) {
			listeners.add(listener);
		} 
	}
	private static void callListers(IUserSession session, IRequestHandler rh) throws Exception {
		if (listeners.size() != 0 ) {
			for (int i = 0 ; i < listeners.size() ; i++) {
				ISessionCreateListener listener = (ISessionCreateListener)listeners.get(i);
				listener.create(session,rh);
			}
		}
	}
	/** 
	 * UserSessionNX𐶐܂B
	 * @param 			rh	java.sql.Connection擾邽߂ɎgpIRequestHandler
	 */	
	public static IUserSession create(IRequestHandler rh) throws Exception {
		HttpSession hs = rh.getRequest().getSession(false);
		if ( hs == null ) {
			hs = rh.getRequest().getSession(true);
			UserSession us = new UserSession(hs);
			hs.setAttribute(UserSession.SESSION_NAME, us);
			callListers(us, rh);
			return us;
		} else {
			if (hs.getAttribute(UserSession.SESSION_NAME) != null) {
				return (UserSession)hs.getAttribute(UserSession.SESSION_NAME);
			} else {
				UserSession us = new UserSession(hs);
				hs.setAttribute(UserSession.SESSION_NAME, us);
				callListers(us, rh);
				return (UserSession)hs.getAttribute(UserSession.SESSION_NAME);
			}
		}
	}
	
	/** 
	 * UserSessionNX𐶐܂B
	 * @param 			rh	java.sql.Connection擾邽߂ɎgpRequestHandler
	 * @return 		Authenticate 	擾AuthenticateNX̃CX^XB
	 * @exception 	Exception
	 */	
	public static IUserSession create(IRequestHandler rh, String user) throws Exception {
		HttpSession hs = rh.getRequest().getSession(false);
		if ( hs == null ) {
			hs = rh.getRequest().getSession(true);
			UserSession us = new UserSession(hs,user);
			hs.setAttribute(UserSession.SESSION_NAME, us);
			callListers(us, rh);
			return us;
		} else {
			if (hs.getAttribute(UserSession.SESSION_NAME) != null) {
				return (UserSession)hs.getAttribute(UserSession.SESSION_NAME);
			} else {
				UserSession us = new UserSession(hs,user);
				hs.setAttribute(UserSession.SESSION_NAME, us);
				callListers(us, rh);
				return (UserSession)hs.getAttribute(UserSession.SESSION_NAME);
			}
		}	}

}
