package wisdom.core.util;

import java.util.*;
import java.sql.*;

/**
 * t̂߂̃[eBeBNXłB
 * 
 * @author TK
 * @version 1.1 2003/12
 * 
 */
public class DateUtil {
	/**
	 * ̔z<br>
	 * z01Ƃ12܂ł̌܂܂Ă܂B228ɂȂĂ܂B<br>
	 * 
	 */
	public static int[] daysOfMonth = new int[] {31,28,31,30,31,30,31,31,30,31,30,31};
	
	/**
	 *  ĵ{Ŏ擾邽߂̒萔B
	 */
	public static final int JAPANESE = 1000;
	
	/**
	 *  ĵpŎ擾邽߂̒萔B
	 */
	public static final int ENGLISH = 1001;
	
	/**
	 * j́i{jStringzB<br>
	 * z0""Ƃ""܂ł̗ĵ܂܂܂B
	 */
	public static final String[] weekJapan = {"","","","","","y",""};


	/**
	 * j́ipjStringzB<br>
	 * z0"Mon"Ƃ"Sun"܂ł̗ĵ܂܂܂B
	 */
	public static final String[] weekEnglish = {"Mon","Tue","Wed","Thu","Fri","Sat","Sun"};	
	
	/**
	 * String^ԂƂđÓ邩Ó̌s܂B<br>
	 * dateɂ yyyymmddœt͂ĂƑz肵܂B<br>
	 * Ó̏<br>
	 * 1)8邩BiSp͕sj<br>
	 * 2)ׂĐB<br>
	 * 3)̒lłȂ<br>
	 * 4)̒li5`6j1`12͈̔͂<br>
	 * 5)̒li7`8jw肳ꂽɑÓ̂ti邤N`FbN܂j<br>
	 * 
	 * @param		date	N܂܂ꂽ
	 * @return		int		-3 8ȂAׂĐłȂA̒l͂Ăꍇ
	 * 						-2  ̎w肪Ȃ
	 * 						-1  ̒lȂ
	 * 						 0  l̏ꍇ
	 */
	public static int chkDateString(String date) {
		if (date.getBytes().length != 8) return -3;
		for (int i = 0 ; i < 8 ; i++) {
			if (!Character.isDigit(date.charAt(i))) return -3;
		}
		if (Integer.parseInt(date) < 0) return -3;
		int year 	= Integer.parseInt(date.substring(0,4));
		int month 	= Integer.parseInt(date.substring(4,6));
		int day 	= Integer.parseInt(date.substring(6,8));
		if ((month < 1) || (month > 12))  return -2;
		if (day < 1 ) return -1;
		if (day > getLastDayOfMonth(year,month)) return -1;
		return 0;
	}
	/**
	 * dateN؂蕶ȂŔ܂B<br>
	 * 
	 * @param		date		Timestamp
	 * @return		String		yyyymmddŔꂽTimestamp̒l
	 * 							datenull̏ꍇnullԂ܂B
	 */
	public static String getStringDate(Timestamp date) {
		if (date == null) return null;
		Calendar c = new GregorianCalendar();
		c.setTime(date);

		StringBuffer sb = new StringBuffer(fillDigits(4, c.get(Calendar.YEAR), 0));
		sb.append(fillDigits(2, c.get(Calendar.MONTH)+1, 0)).
		append(fillDigits(2, c.get(Calendar.DATE), 0));
		return sb.toString();		
	}
	/**
	 * ݎԂ擾܂B<br>
	 * @return int 
	 */	
	public static int getTime() {
		
		Calendar c = new GregorianCalendar();
		StringBuffer sb = new StringBuffer(fillDigits(2, c.get(Calendar.HOUR_OF_DAY), 0));
		sb.append(fillDigits(2, c.get(Calendar.MINUTE), 0));
		sb.append(fillDigits(2, c.get(Calendar.SECOND), 0));
		
		return Integer.parseInt(sb.toString());
	}
	
	/**
	 * Ԃ^ꂽ؂蕶ŕԂ<BR>
	 * @param delim ؂蕶 (:ȂǁAuN̏ꍇ͖܂j
	 * @return String 
	 */	
	public static String getStringTime(String delim) {
		boolean isDelim = false;
		if ((delim != null) && delim.length() !=0) isDelim = true;
		
		Calendar c = new GregorianCalendar();
		StringBuffer sb = new StringBuffer(fillDigits(2, c.get(Calendar.HOUR_OF_DAY), 0));
		
		if (isDelim) sb.append(delim);
		sb.append(fillDigits(2, c.get(Calendar.MINUTE), 0));
		
		if (isDelim) sb.append(delim);
		sb.append(fillDigits(2, c.get(Calendar.SECOND), 0));
		
		return sb.toString();
	}

	/**
	 * tԂ<BR>
	 * @return String 
	 */	
	public static int getDate() {
		Calendar c = new GregorianCalendar();
		StringBuffer sb = new StringBuffer(fillDigits(2, c.get(Calendar.YEAR), 0));
		
		sb.append(fillDigits(2, c.get(Calendar.MONTH) + 1, 0));
		
		sb.append(fillDigits(2, c.get(Calendar.DATE), 0));
		
		return Integer.parseInt(sb.toString());
	}		

	/**
	 * t^ꂽ؂蕶ŕԂ<BR>
	 * @param delim ؂蕶 (/ȂǁAuN̏ꍇ͖܂j
	 * @return String 
	 */	
	public static String getStringDate(String delim) {
		boolean isDelim = false;
		if ((delim != null) && delim.length() !=0) isDelim = true;
		
		Calendar c = new GregorianCalendar();
		StringBuffer sb = new StringBuffer(fillDigits(2, c.get(Calendar.YEAR), 0));
		
		if (isDelim) sb.append(delim);
		sb.append(fillDigits(2, c.get(Calendar.MONTH) + 1, 0));
		
		if (isDelim) sb.append(delim);
		sb.append(fillDigits(2, c.get(Calendar.DATE), 0));
		
		return sb.toString();
	}	

	/**
	 * t^ꂽ؂蕶ŕԂ<BR>
	 * @return String 
	 */	
	public static String getStringDate() {
		Calendar c = new GregorianCalendar();
		StringBuffer sb = new StringBuffer(fillDigits(2, c.get(Calendar.YEAR), 0));
		
		sb.append(fillDigits(2, c.get(Calendar.MONTH) + 1, 0));
		
		sb.append(fillDigits(2, c.get(Calendar.DATE), 0));
		
		return sb.toString();
	}	

	/**
	 * ^ꂽint^̐E񂹂ɂĎw肳ꂽ܂Ő𖄂߂<BR>
	 * @param d ߂Strinǧ
	 * @param digits ߂Stringɖ߂鐔
	 * @param fillDigit digits߂ꂽStringɑ΂Ė߂錅܂Ŗ߂鐔
	 * @return String 
	 */	
	public static String fillDigits(int d, int digits, int fillDigit) {
		StringBuffer sb = new StringBuffer(d);
		String s1 = String.valueOf(digits);
		String s2 = String.valueOf(fillDigit);
		int max = d - s1.length();
		for (int i = 0 ; i < max ; i++) sb.append(s2);
		return sb.append(s1).toString();
	}

	/**
	 * NԂ܂<BR>
	 * @return int 
	 */	
	public static int getYear() {
		Calendar c = new GregorianCalendar();
		return c.get(Calendar.YEAR);
	}

	/**
	 * Ԃ܂<BR>
	 * @return int 
	 */	
	public static int getMonth() {
		Calendar c = new GregorianCalendar();
		return c.get(Calendar.MONTH) + 1;
	}

	/**
	 * Ԃ܂<BR>
	 * @return int 
	 */	
	public static int getHour() {
		Calendar c = new GregorianCalendar();
		return c.get(Calendar.HOUR_OF_DAY);
	}

	/**
	 * Ԃ܂<BR>
	 * @return int 
	 */	
	public static int getMinute() {
		Calendar c = new GregorianCalendar();
		return c.get(Calendar.MINUTE);
	}

	/**
	 * bԂ܂<BR>
	 * @return int 
	 */	
	public static int getSecond() {
		Calendar c = new GregorianCalendar();
		return c.get(Calendar.SECOND);
	}

	/**
	 * NԂ܂<BR>
	 * @return String 
	 */	
	public static String getStringYear() {
		Calendar c = new GregorianCalendar();
		return fillDigits(4, c.get(Calendar.YEAR), 0);
	}

	/**
	 * Ԃ܂<BR>
	 * @return String 
	 */	
	public static String getStringMonth() {
		Calendar c = new GregorianCalendar();
		return fillDigits(2, c.get(Calendar.MONTH) +1, 0);		
	}

	/**
	 * Ԃ܂<BR>
	 * @return String 
	 */	
	public static String getStringDay() {
		Calendar c = new GregorianCalendar();
		return fillDigits(2, c.get(Calendar.DATE), 0);		
	}		

	/**
	 * Ԃ܂<BR>
	 * @return String 
	 */	
	public static String getStringHour() {
		Calendar c = new GregorianCalendar();
		return fillDigits(2, c.get(Calendar.HOUR_OF_DAY), 0);		
	}

	/**
	 * Ԃ܂<BR>
	 * @return String 
	 */	
	public static String getStringMinute() {
		Calendar c = new GregorianCalendar();
		return fillDigits(2, c.get(Calendar.MINUTE), 0);
	}

	/**
	 * bԂ܂<BR>
	 * @return String 
	 */	
	public static String getStringSecond() {
		Calendar c = new GregorianCalendar();
		return fillDigits(2, c.get(Calendar.SECOND), 0);
	}
	/**
	 * p[^̔NAATimeStamp쐬܂B<BR>
	 * ̃\bh͎Ԃ00:00:00ō쐬܂B
	 * @param year N
	 * @param month  
	 * @param day   
	 * @return Timestamp 
	 */	
	public static Timestamp getTimestamp(String year, String month, String day) {
		StringBuffer sb = new StringBuffer();
		sb.append(fillDigits(4, Integer.parseInt(year), 0)).append("-").
			append(fillDigits(2, Integer.parseInt(month), 0)).append("-").
			append(fillDigits(2, Integer.parseInt(day), 0)).append(" 00:00:00.0");
		return Timestamp.valueOf(sb.toString());	
	}	

	/**
	 * p[^̔NAAAԂTimeStamp쐬܂B<BR>
	 * @param year N
	 * @param month  
	 * @param day   
	 * @param time   
	 * @return Timestamp 
	 */	
	public static Timestamp getTimestamp(String year, String month, String day, String time) {
		StringBuffer sb = new StringBuffer();
		sb.append(fillDigits(4, Integer.parseInt(year), 0)).append("-").
			append(fillDigits(2, Integer.parseInt(month), 0)).append("-").
			append(fillDigits(2, Integer.parseInt(day), 0)).append(" ").append(time).append(".0");
		return Timestamp.valueOf(sb.toString());	
	}	

	/**
	 * p[^TimeStampNAAɕϊ܂<BR>
	 * @param t Timestamp
	 * @return String 
	 */	
	public static String getTimestamp(Timestamp t) {
		return t.toString().substring(2, 11).replace('-','/');
	}	
	
	/**
	 * p[^TimeStampNAA̘Aɕϊ܂<BR>
	 * @param 	t Timestamp
	 * @param	delim	
	 * @return String 
	 */	
	public static String cnvTimestamp(Timestamp t, String delim) {
		String time = t.toString();
		StringBuffer sb = new StringBuffer(time.substring(0,4));
		if (StringUtil.notEmpty(delim)) sb.append(delim);
		sb.append(time.substring(5,7));
		if (StringUtil.notEmpty(delim)) sb.append(delim);		
		sb.append(time.substring(8,10));
		return sb.toString();
	}		

	/**
	 * p[^ Timestamp ʕ\pi9999/99/99 99:99 ̌`jɕҏW܂B<BR>
	 * p[^ NULL ̏ꍇ́A"*" Ԃ܂B
	 * @param t Timestamp
	 * @return String ҏWꂽ
	 */
	public static String getDisplayDateTime(Timestamp t) {
		if (t == null) return "*";
		return t.toString().substring(0, 16).replace('-','/');
	}

	/**
	 * p[^String(NAA)ɓĂƑz肵Timestampɕϊ܂<BR>
	 * @param 	date
	 * @return 	Timestamp 
	 */	
	public static Timestamp getTimestamp(String date) {
		int year 	= Integer.parseInt(date.substring(0,4));
		int month 	= Integer.parseInt(date.substring(4,6));
		int day 	= Integer.parseInt(date.substring(6,8));
		GregorianCalendar gc = new GregorianCalendar(year,month-1,day);
		return new Timestamp(gc.getTime().getTime());
	}

	/**
	 * p[^String(NAA),String(FFb)ɓĂƑz肵Timestampɕϊ܂<BR>
	 * @param 	date
	 * @return 	Timestamp 
	 */	
	public static Timestamp getTimestamp(String date,String time) {
		int year 	= Integer.parseInt(date.substring(0,4));
		int month 	= Integer.parseInt(date.substring(4,6));
		int day 	= Integer.parseInt(date.substring(6,8));
		
		int hour 	= Integer.parseInt(time.substring(0,2));
		int minute 	= Integer.parseInt(time.substring(2,4));
		int second 	= Integer.parseInt(time.substring(4,6));

		GregorianCalendar gc = new GregorianCalendar(year,month-1,day,hour,minute,second);
		
		return new Timestamp(gc.getTime().getTime());
	}


	/**
	 * ݂̓tTimestampIuWFNgŎ擾܂B<BR>
	 * @return Timestamp ݂̓t
	 */	
	public static String getTimestamp() {
		String now_date = "";
		java.util.Calendar c = java.util.Calendar.getInstance();
		String year = String.valueOf( c.get(java.util.Calendar.YEAR) );
		String month = String.valueOf( c.get(java.util.Calendar.MONTH)+1 );
		String day = String.valueOf( c.get(java.util.Calendar.DAY_OF_MONTH) );
		String hour = String.valueOf(c.get(java.util.Calendar.HOUR_OF_DAY));
		String min = String.valueOf(c.get(java.util.Calendar.MINUTE));
		String sec = String.valueOf(c.get(java.util.Calendar.SECOND));

		if( month.length() == 1 ) month = "0" + month;
		if( day.length() == 1 )	day = "0" + day;
		if( hour.length() == 1)	hour="0"+hour;
		if( min.length() == 1)	min="0"+min;
		now_date = year +"-"+ month +"-"+ day +" "+ hour +":"+ min;

		return now_date;
	} 
	
	/**
	 * Ň擾܂B<BR>
	 * @param year N
	 * @param month  
	 * @return int lastDay
	 */	
	public static int getLastDayOfMonth(int year, int month) {
		GregorianCalendar gc = new GregorianCalendar(year, month, 1);
		if ((month == 2) && (gc.isLeapYear(year))) return daysOfMonth[month-1]+1; /* 邤N */
		return daysOfMonth[month-1];
	}
	/**
	 * ĵ̖擾܂B<br>
	 * ꂼ̈ȂꍇA0StringԂ܂B
	 *
	 * @param week jBrCalendar萔Ŕʂ܂B
	 * @param nameType ̂̃^CvBDateUtil.JAPANESE܂DateUtil.ENGLISHŎw肵܂B
	 * @return String j
	 * @see java.util.Calendar
	 */
	public static String getDayOfWeekName(int week, int nameType) {
		if ( (nameType != ENGLISH) && (nameType != JAPANESE) ) return "";
		
		switch (week) {
			case(Calendar.MONDAY)	:
					if (nameType == JAPANESE) return weekJapan[0];
					else return weekEnglish[0];
			case(Calendar.TUESDAY)	:
					if (nameType == JAPANESE) return weekJapan[1];
					else return weekEnglish[1];
			case(Calendar.WEDNESDAY)	:
					if (nameType == JAPANESE) return weekJapan[2];
					else return weekEnglish[2];
			case(Calendar.THURSDAY)	:
					if (nameType == JAPANESE) return weekJapan[3];
					else return weekEnglish[3];
			case(Calendar.FRIDAY)	:
					if (nameType == JAPANESE) return weekJapan[4];
					else return weekEnglish[4];
			case(Calendar.SATURDAY)	:
					if (nameType == JAPANESE) return weekJapan[5];
					else return weekEnglish[5];
			case(Calendar.SUNDAY)	:
					if (nameType == JAPANESE) return weekJapan[6];
					else return weekEnglish[6];
			default	:	return "";
		}
	}

}