package wisdom.core.util;

import java.io.*;
import java.util.*;

/**
 * 񑀍W߂[eBeBNX<br>
 *
 * @author Takao Kouda
 * @version 1
 */
public class StringUtil implements Serializable {

	/**
	 * RXgN^<br>
	 * X^eBbNȃ\bhgpۂStringUtil.catArray()ȂǁA
	 * 璷ȋLqɂȂ̂h߂ɗpӂĂ܂B
	 * StringUtil su = null;<br>
	 * ł։\łB
	 */
	public StringUtil() {}

	/**
	 * z,ŘA܂Bz'ŋ؂܂B<br>
	 *
	 * Ex)	StringUtil.catArray(new String[] {"ABC","DE","FG"});<br>
	 * ʂ<br>
	 * "'ABC','DF','FG'"ƂȂ܂B
	 *
	 * @param array z
	 * @return String A̕
	 */
	public static String catArray(String[] array) {
		return catArray(array, ",", "'");
	}
	
	/**
	 * zw肵؂蕶ŘA܂Bz'ŋ؂܂B
	 *
	 * Ex)	StringUtil.catArray(new String{}{"ABC","DE","FG"}, "'");<BR>
	 * ʂ<BR>
	 * "'ABC','DF','FG'"ƂȂ܂B
	 *
	 * @param array z
	 * @param delim ؂蕶
	 * @return String A̕
	 */

	public static String catArray(String[] array, String delim) {
		return catArray(array, delim, "'");
	}

	/**
	 * zw肵؂蕶ŘA܂Bz͈̈pŋ؂܂B
	 *
	 * Ex)	StringUtil.catArray(new String{}{"ABC","DE","FG"}, "'", ",");<BR>
	 * ʂ<BR>
	 * "'ABC','DF','FG'"ƂȂ܂B
	 *
	 * @param array z
	 * @param delim ؂蕶
	 * @param quote zɎgpp
	 * @return String A̕
	 */
	public static String catArray(String[] array, String delim, String quote) {
		StringBuffer sb = new StringBuffer();
		
		boolean isFirst = true;
		
		for (int i = 0 ; i < array.length ; i++) {
			
			if (notEmpty(array[i])) {
				
				if (!isFirst) sb.append(delim);
				
				sb.append(quote).append(array[i]).append(quote);
				
				isFirst = false;
				
			}
		}
		return sb.toString();
	}
		
	/**
	 * nꂽ̒Ŏw肳ꂽu܂B<br>
	 *
	 * @param source u镶
	 * @param target uΏۂ̕
	 * @param replaceStr u镶 
	 * @return String uꂽ
	 */
	public static String replace(String source, String target, String replaceStr) {
		if ( source == null || target == null || replaceStr == null ) return source;
		int  index = source.indexOf(target);
		if ( index == -1 ) return source;
		int i = 0;
		int length = target.length();
		StringBuffer sb = new StringBuffer();
		while ( (index = source.indexOf(target, i)) != -1) {
			sb.append(source.substring(i, index)).append(replaceStr);
			i = index + length;
		}
		sb.append(source.substring(i));
		return sb.toString();
	}	
	/**
	 * ̃̕oCg擾܂B
	 * 
	 * @param	source oCg擾镶
	 * @return 		sourcẽoCgisourcenull̏ꍇ0j
	 */
	public static int getByteLength(String source) {
			if (source == null) return 0;
			return source.getBytes().length;
		}
	/**
	 * ̕nullA܂͒0łȂꍇtrueԂ܂B
	 * @param s 镶
	 * @return boolean true=nullłȂA0̏ꍇ
	 */
	public static boolean notEmpty(String s) {

		if ((s == null) || (s.trim().length() == 0)) return false;
		
		return true;
	}	

	/**
	 * ̕nullA܂͒0̏ꍇtrueԂ܂B
	 * @param s 镶
	 * @return boolean true=nullłȂA0̏ꍇ
	 */
	public static boolean isEmpty(String s) {

		if ((s == null) || (s.trim().length() == 0)) return true;
		
		return false;
	}
	
	/**
	 * ̕znullA܂͒0̏ꍇtrueԂ܂B
	 * @param s 镶
	 * @return boolean true=nullłȂA0̏ꍇ
	 */
	public static boolean notEmptyArray(String[] s) {
		for (int i = 0 ; i < s.length ; i++ ) {
			if (notEmpty(s[i])) return true;
		}	
		return false;
	}	

	/**
	 * ̕null̏ꍇ""i0̕jɕϊ܂B
	 * @param source ϊ镶
	 * @return String ϊ̕
	 */
	public static String cnvNull(String source) {
		if (source == null) return "";
		return source;		
	}

	/**
	 * ̕null̏ꍇ""i0̕jɕϊ܂BnullłȂꍇ͖߂ltrim܂B
	 * @param source ϊ镶
	 * @return String ϊ̕
	 */
	public static String cnvNullTrim(String source) {
		if (source == null) return "";
		return source.trim();
	}
	/**
	 * ̕null̏ꍇɕϊ̕ɕϊ܂B
	 * ϊpnull̏ꍇnullԂ܂B
	 * @param source 	ϊ镶
	 * @param target 	sourcenull̏ꍇɎgpϊp
	 * @return String 	ϊ̕
	 */
	public static String cnvNull(String source, String target) {
		if (source == null) return target;
		return source;		
	}	
	/**
	 * source̒0̏ꍇAnull߂܂B<br>
	 * @param source
	 * @return uꂽ
	 */
	public static String toNull(String source) {
		if (isEmpty(source)) return null;
		return source;
	}
	
	/**
	 * ̕񂪐ƂĈꍇtrueԂ܂BiuN0Ƃ݂ȂtrueԂ܂Bj<BR>
	 *
	 * @param s 镶
	 * @return boolean true=nullłȂA0̏ꍇ
	 */
	public static boolean isNumeric(String s) {

		if ((s == null) || (s.trim().length() == 0)) return true;
		try {
			int x = Integer.parseInt(s);
		} catch (NumberFormatException nfe) {
			return false;
		}
		return true;
	}

	/**
	 * ̕񂪌ƂĈꍇtrueԂ܂BiuN0Ƃ݂ȂfalseԂ܂Bj<BR>
	 *
	 * @param s 镶
	 * @return boolean true=nullłȂA0̏ꍇ
	 */
	public static boolean isMonth(String s) {
		if (isEmpty(s)) return false;
		if (!isNumeric(s)) return false;
		int x = Integer.parseInt(s);		
		if (0 < x && x < 13) return true;
		return false;
	}
	/**
	 * ̕񂪓ƂĈꍇtrueԂ܂BiuN0Ƃ݂ȂfalseԂ܂Bj<BR>
	 *
	 * @param s 镶
	 * @return boolean true=nullłȂA0̏ꍇ
	 */
	public static boolean isDay(String s) {
		if (isEmpty(s)) return false;
		if (!isNumeric(s)) return false;
		int x = Integer.parseInt(s);		
		if (0 < x && x < 32) return true;
		return false;
	}	
	/**
	 * ̕񂪎ƂĈꍇtrueԂ܂BiuN0Ƃ݂ȂfalseԂ܂Bj<BR>
	 * ԂƗLȔ͈͂023܂ł̊ԂłB
	 *
	 * @param s 镶
	 * @return boolean true=nullłȂA0̏ꍇ
	 */
	public static boolean isHour(String s) {
		if (isEmpty(s)) return false;
		if (!isNumeric(s)) return false;
		int x = Integer.parseInt(s);		
		if (0 <= x && x <= 23) return true;
		return false;
	}
	/**
	 * ̕񂪕ƂĈꍇtrueԂ܂BiuN0Ƃ݂ȂfalseԂ܂Bj<BR>
	 * ƂėLȔ͈͂059łB
	 *
	 * @param s 镶
	 * @return boolean true=nullłȂA0̏ꍇ
	 */
	public static boolean isMinute(String s) {
		if (isEmpty(s)) return false;
		if (!isNumeric(s)) return false;
		int x = Integer.parseInt(s);		
		if (0 <= x && x <= 59) return true;
		return false;
	}
	/**
	 * ̕񂪕bƂĈꍇtrueԂ܂BiuN0Ƃ݂ȂfalseԂ܂Bj<BR>
	 * ƂėLȔ͈͂059łB
	 * 
	 * @param s 镶
	 * @return boolean true=nullłȂA0̏ꍇ
	 */
	public static boolean isSecond(String s) {
		return isMinute(s);
	}
	/**
	 * ̕񂪋̏ꍇA"0"ɕϊ܂B
	 *
	 * @param s 镶
	 * @return boolean true=nullłȂA0̏ꍇ
	 */
	public static String cnvEmptyToZero(String s) {
		if (isEmpty(s)) return "0";
		else return s;
	}
	/**
	 * ̕񂪋̏ꍇAdefɕϊ܂B
	 *
	 * @param s 镶
	 * @return boolean true=nullłȂA0̏ꍇ
	 */
	public static String cnvEmptyToZero(String s, int def) {
		if (isEmpty(s)) return Integer.toString(def);
		else return s;
	}		

	/**
	 * R[hy[WCp932ɕϊ܂B
	 * @param s ϊ镶
	 * @return String ϊ̕
	 */
    public static String toCp932(String s) {
		StringBuffer sb = new StringBuffer();
		char c;
		for (int i = 0; i < s.length(); i++) {
			c  = s.charAt(i);
			switch (c) {
			    case 0x005c:	c = 0xff3c;	 	break;	 /*	REVERSE SOLIDUS -> FULLWIDTH REVERSE SOLIDUS */
			    case 0x301c:	c = 0xff5e;		break;	 /* WAVE DASH -> FULLWIDTH TILDE */
			    case 0x2016:	c = 0x2225;		break;	 /* DOUBLE VERTICAL LINE -> PARALLEL TO */
			    case 0x2212:	c = 0xff0d;		break;   /* MINUS SIGN -> FULLWIDTH HYPHEN-MINUS */
			    case 0x00a2:	c = 0xffe0; 	break;	 /* CENT SIGN -> FULLWIDTH CENT SIGN */
			    case 0x00a3:	c = 0xffe1;		break;   /* POUND SIGN -> FULLWIDTH POUND SIGN	*/
			    case 0x00ac:	c = 0xffe2;	 	break;	 /* NOT SIGN -> FULLWIDTH NOT SIGN	*/
		    }
		    sb.append(c);
		}
		return new String(sb);
	}	
	/**
	 * 16i\ɕϊ܂B<br>
	 * @param source ϊ镶
	 * @return String ϊ̕
	 */ 
	public static String toHexString(String source) {
		StringBuffer sb = new StringBuffer();
		for(int i = 0 ; i < source.length() ; i++){
			sb.append("&#x")
			.append(Integer.toHexString((int)source.charAt(i)))
			.append(";");
		}
		return sb.toString();
	}
	/**
	 * w肳ꂽ(data)̒ł̕(target)̏o񐔂Ԃ܂B
	 * 
	 * @param		data		镶
	 * @param		target		܂܂镶
	 * @return 		int			(target)o
	 */ 
	public static int count(String data, String target) {
		int count = 0;
		for ( int index = 0; (index = data.indexOf(target, index)) != -1; index++, count++ ) ;
		return count;
	}
	
	/**
	 * [AhX̃`FbNs܂B
	 * @param str `FbN
	 * @return boolean true͔Fł
	 */
	public static boolean isMailAddress(String str) {
        int     atmk    = 0;
        int     dotcnt  = 0;
        int     clmk    = 0;

        for (int i = 0; i < str.length(); i++){
			char c = str.charAt(i);
            if (!isAsciiChar(str.charAt(i))){
                return false;
            }
            if (c == '@'){
            	atmk++;
            }
            if (c == '.'){
                clmk++;
				if (i == 0 || (str.charAt(i-1) == '@')){
					return false;
				} else if (str.length() <= i+1 || (str.charAt(i+1) == '@')){
					return false;
				}
            }
        }
        if (atmk == 1 && clmk != 0 && Character.isJavaIdentifierPart(str.charAt(0))){
            return true;
        }
        else{
            return false;
        }
	}
	/**
	 * AXL[̃`FbNs܂B(char)
	 * @param c `FbN(char)
	 * @return boolean true͔Fł
	 */
	private static boolean isAsciiChar(char c) {
		try {
			return (c < 0x007f && c >= 0x0020);
		} catch (Exception ex) {
			return false;
		}
	}	
}