package wisdomx.logic.formtemplate;

import java.io.Serializable;

import wisdom.core.CoreObject;
import wisdom.core.Message;
import wisdom.core.MessageList;
import wisdom.core.application.IRequestHandler;
import wisdom.core.application.IRequestParser;
import wisdomx.ui.object.IHasMessageList;
/**
 * o^AXVA폜̉ʕ\ɎgpNXB<br>
 * ̃NX͉ʕ\ɎgpIuWFNgێ邽߂Ɏgp܂B<br>
 * ̃NX̓[hio^AXVA폜j܂B̃NXpʂɕ\IuWFNg̃NX
 * tB[hƂĒ`Asetter/getterǉ܂B<br>
 * ̃IuWFNg̐{@link AbstractFormObjectGenerator }̃TuNXōsA
 * {@link wisdomx.logic.formtemplate.AbstractFormObjectPersistance}̃TuNXɂo^AXVA폜s܂B 
 *
 * @author  Takao Kouda
 * @version 1
 * @see AbstractFormObjectGenerator
 * @see wisdomx.logic.formtemplate.AbstractFormObjectPersistance
 */          
public abstract class AbstractFormObject extends CoreObject implements Serializable, IHasMessageList {
	
    /**
     * RXgN^<br>
     *  {@link #isInsert() }turȅԂłB
     */ 
    public AbstractFormObject()  { super(); }
    
    /**
     * TuNXŒǉtB[hɒlݒ肷s܂B<br>
     * 
     * @param rh
     * @throws Exception
     */
    public abstract void set(IRequestHandler rh, IRequestParser rp) throws Exception;
    
    
    /**
     * o^[h܂B<br>
     * 
     * @return o^[h̏ꍇtrue
     */
	public boolean isInsert() {
		return mode == INSERT;
	}
	/**
	 * XV[h܂B<br>
	 * 
	 * @return XV[h̏ꍇtrue
	 */
	public boolean isUpdate() {
		return mode == UPDATE;
	}

	/**
	 * 폜[h܂B<br>
	 * 
	 * @return 폜[h̏ꍇtrue
	 */
	public boolean isDelete() {
		return mode == DELETE;
	}
	
	/**
	 * o^[hɐݒ肵܂B<br>
	 * 
	 */
	public void toInsert() {
		mode = INSERT;
	}
	/**
	 * XV[hɐݒ肵܂B<br>
	 * 
	 */
	public void toUpdate() {
		mode = UPDATE;
	}
	
	/**
	 * 폜[hɐݒ肵܂B<br>
	 * 
	 */
	public void toDelete() {
		mode = DELETE;
	}
    
	/**
	 * w肳ꂽR[h̃bZ[W܂B<br>
	 * rcode.equals(Message#getCode()) == true ̎^ɂȂ܂B
	 * ̃\bhsĂAAbstractFormObject̃G[Ԃ͕ς܂B
	 * 
	 * @param code 郁bZ[W̃R[h
	 */
	public void removeMessage(String  code) {
		messageList.remove(code);
	}    

/* IHasMessageList̎ Jn*/
    public void addErrorMessage(Message errorMessage) {
    	if (errorMessage == null) return;
        messageList.addMessage(errorMessage);
        error = true;
    }
	public void addErrorMessages(MessageList errorMessages) {
		if (errorMessages == null || errorMessages.size() == 0) return;
		messageList.addMessages(errorMessages);
		error = true;
	}    
    public void addMessage(Message message) {
		if (message == null) return;
        messageList.addMessage(message);
    }
	public void addMessages(MessageList messages) {
		if (messages == null || messages.size() == 0 ) return;
		messageList.addMessages(messages);
	}

    public MessageList getMessageList() {
        return messageList;
    }
    
	public int messageSize() {
		return messageList.size();
	}

	public Message getMessage(int index) {
		return messageList.get(index);
	}
	public void clearMessageList() {
		messageList.clear();
		error = false;
	}

	public boolean isError() {
		return error;
	}

	public boolean containsMessageByFieldId(String field) {
		return messageList.contain(field);
	}
		
/* IHasMessageList̎ I*/

    
	/** ÓBitrue=Afalse=G[j */
	private boolean error = false;
	
	/** [h萔(o^)  */
	private static final int INSERT = 100;
	/** [h萔(XV)  */
	private static final int UPDATE = 200;
	/** [h萔(폜)  */    
	private static final int DELETE = 300;
	
	/** XV[h ilINSERTłB   */ 
	private int mode = INSERT ;
	
	/** bZ[Wۑz   */
	private MessageList messageList = new MessageList();

}
