package wisdomx.logic.formtemplate;

import java.io.Serializable;
import java.sql.SQLException;

import wisdom.core.CoreObject;
import wisdom.core.CoreRuntimeException;
import wisdom.core.MessageGenerator;
import wisdom.core.application.AppMessageGenerator;
import wisdom.core.application.IRequestHandler;
import wisdom.core.application.IRequestParser;

/**
 * AbstractFormObject̍XVsNXB<br>
 * AbstractFormObject̃TuNXŒ`ꂽtB[hf[^擾Af[^XV܂B 
 * 
 * AbstractFormObject̃[hɂo^AXVA폜܂B
 * NXp҂͈ȉ̏Ŏgp܂B
 * <br><br>
 * <b>sAꍇAsʂ\</b><br>
 * <pre>
 * AbstractFormObject formObject = (AbstractFormObject)rh.getSessionAttribute("fCustomer");
 * AbstractFormObjectPersistance formObjectPersister = new CustomerFormObjectPersister(formObject, rh);
 * formObject = formObjectPersister.execute();                 ÓAXVs܂B
 * if (formObject.isError()) setPage("customerEdit.jsp");      ҏWʂɖ߂܂
 * setPage("customerConfirm.jsp");                             mFʂ\܂<br><br>
 * </pre>
 * <br>
 * <b>sAꍇmFʂ\</b><br>
 * <pre>
 * AbstractFormObject formObject = (AbstractFormObject)rh.getSessionAttribute("fCustomer");
 * AbstractFormObjectPersistance formObjectPersister = new CustomerFormObjectPersister(formObject, rh);
 * formObject = formObjectPersister.validate();
 * if (formObject.isError()) setPage("customerEdit.jsp");      ҏWʂɖ߂܂
 * setPage("customerConfirm.jsp");                             mFʂ\܂<br><br>
 * </pre>
 * <br>
 * <b>mFʂXVs</b><br>
 * <pre>
 * AbstractFormObject formObject = (AbstractFormObject)rh.getSessionAttribute("fCustomer");
 * AbstractFormObjectPersistance formObjectPersister = new CustomerFormObjectPersister(formObject, rh);
 * formObjectPersister.setIgnoreValidate(true);                ͍ςł̂ŏȗ܂
 * formObject = formObjectPersister.execute();                 XVs܂B
 * setPage("customerComplete.jsp");                            ʂ\܂
 * </pre>
 * <br>
 * 
 * @author Takao Kouda
 * @version 1
 */
public abstract class AbstractFormObjectPersistance extends CoreObject implements Serializable {
	/**
	 * TuNXŎgpł{@link IRequestHandler }̃CX^X<br>
	 */
  	protected IRequestHandler rh = null;
  	/**
  	 * TuNXŎgpł{@link IRequestParser}̃CX^X<br>
  	 */
  	protected IRequestParser rp = null;
  	
	/** 
	 * ̃IuWFNgisUpdateForm̃CX^X<br>
	 * RXgN^̒lݒ肳܂B
	 */
    protected AbstractFormObject formObject = null;

    /** 
     * TuNXŃbZ[W擾邽߂MessageGenerator̃CX^X<br>
     * IuWFNg{@link AppMessageGenerator }̃CX^X擾܂B
     */
    protected MessageGenerator messageGenerator = null;

  	
  	public AbstractFormObjectPersistance(AbstractFormObject formObject, IRequestHandler rh) throws Exception { 
  		this.formObject = formObject;
		this.rh = rh;
		this.rp = rh.getRequestParser();
		messageGenerator = AppMessageGenerator.getInstance();
  	}
	
	/**
	 * NXp҂sXV\bhłB<br>
	 * sɈȉ̏s܂B<br>
	 * 1. {@link #_prepare(AbstractFormObject)}s܂BTuNXAbstractFormObjectTuNX
	 * tB[hǉANXŎgpł悤ɒu܂B<br>
	 * 
	 * 2. {@link #isIgnoreValidate()}falsêƂA{@link #_validate()}s܂B<br>
	 * 
	 * 3-1. {@link AbstractFormObject#isInsert()}truêƂA{@link #_insert()}s܂B<br>
	 * 3-2. {@link AbstractFormObject#isUpdate()()}truêƂA{@link #_update()}s܂B<br>
	 * 3-3. {@link AbstractFormObject#isDelete()()()}truêƂA{@link #_delete()}s܂B<br>
	 * 4. sAbstractFormObject߂܂B<br>
	 * 
	 * @return AbstractFormObject
	 * @exception Exception
	 */ 
    public AbstractFormObject execute() throws Exception {
    	trace("_prepare", "entry");
        _prepare(formObject);
    	trace("_prepare", "exit");        
    	
    	trace("_isValid", "entry");
        if (!ignoreValidate) _validate();
    	trace("_isValid", "exit");        
    	
        if (!formObject.isError()) {
			trace("not error execute");  
        	if (formObject.isInsert()) {
				trace("_insert", "entry");
        		_insert();
				trace("_insert", "exit");
        	} else if (formObject.isUpdate()) {
				trace("_update", "entry");
        		_update();
				trace("_update", "exit");
        	} else if (formObject.isDelete()) {
				trace("_delete", "entry");
        		_delete();
				trace("_delete", "exit");
				
        	} else	throw new CoreRuntimeException(messageGenerator.getMessage("WRE1010", getClass().getName()));
        } else {trace("error.. return");  
        }
        
    	trace("_cleanup", "entry");        
	    _cleanup();
    	trace("_cleanup", "exit");
        return formObject;
    }

	/**
	 * NXp҂sXV\bhłB<br>
	 * sɈȉ̏s܂B<br>
	 * 1. {@link #_prepare(AbstractFormObject)}s܂BTuNXAbstractFormObjectTuNX
	 * tB[hǉANXŎgpł悤ɒu܂B<br>
	 * 
	 * 2. {@link #isIgnoreValidate()}falsêƂA{@link #_validate()}s܂B<br>
	 * 
	 * 3. sAbstractFormObject߂܂B<br>
	 * 
	 * @return AbstractFormObject
	 * @exception Exception
	 */ 
    public AbstractFormObject validate() throws Exception  {
    	trace("_prepare", "entry");    	
        _prepare(formObject);
    	trace("_prepare", "exit");    	        
    	
    	trace("_isValid", "entry");    	            	
        _validate();
    	trace("_isValid", "exit");    	            	
       
    	trace("_cleanup", "entry");          
	    _cleanup();
    	trace("_cleanup", "exit");          	    
        return formObject;
    }

	/**
	 * {@link #execute() }s{@link #_validate()}𖳎邩ݒ肵܂B<br>
	 * 
	 * @param		ignoreValidate	ꍇtrue
	 */
	public void setIgnoreValidate(boolean ignoreValidate) {
		this.ignoreValidate = ignoreValidate;
	}

	/**
	 * {@link #execute() }s{@link #_validate()}邩ݒ肵܂B<br>
	 * 
	 * @return		ignoreValidate	ꍇtrue
	 */
	public boolean isIgnoreValidate() {
		return ignoreValidate;
	}
	/**
	 * o^<br>
	 * TuNXŎ܂B
	 * 
	 * @exception Exception
	 */
	protected abstract void _insert() throws Exception;


	/**
	 * XV<br>
	 * TuNXŎ܂B
	 *  
	 * @exception Exception
	 */
	protected abstract void _update() throws Exception;
    
	/**
	 * 폜<br>
	 * TuNXŎ܂B
	 *  
	 * @exception SQLException
	 * @exception Exception
	 */
    protected abstract void _delete() throws  Exception;


	/**
	 * <br>
	 * TuNXŎ܂B
	 * 
	 * @exception Exception
	 */
    protected abstract void _validate() throws Exception;


	/**
	 * <br>
	 * TuNXŎ܂B
	 * 
	 * @exception Exception
	 */
	 protected abstract void _prepare(AbstractFormObject form) throws Exception;


	/**
	 * ㏈<br>
	 * TuNXŎ܂B
	 * 
	 * @exception Exception
	 */
    protected abstract void _cleanup() throws Exception;
	

	/**
	 *
	 */
	public void setMessageGenerator(MessageGenerator messageGenerator) {
		this.messageGenerator = messageGenerator;
	}

	private boolean ignoreValidate = false;

}
