package wisdomx.logic.formtemplate;


import java.io.Serializable;

import wisdom.core.CoreObject;
import wisdom.core.MessageGenerator;
import wisdom.core.application.AppMessageGenerator;
import wisdom.core.application.IRequestHandler;
import wisdom.core.application.IRequestParser;
import wisdomx.ui.object.IPageList;

/**
 * ͉ʂꗗ`̉ʂ쐬鋤ʃNXB<br>
 * ꗗ`\pIuWFNg{@link wisdomx.ui.object.IPageList }쐬邽߂̃WbNLq܂B
 * NXp҂͈ȉ̏Ŏgp܂B<br>
 * <b></b>
 * <pre>
 * PageListGenerator pgl = new SomePageListGenerator(queryInputForm, requestHandler);
 * if (!pgl.validate()) {
 * 	   setPage("SomeError.jsp");
 * } else {
 *     IPageList result = pgl.generate();
 * 	   rh.setAttribute("pageList", result));
 * 	   setPage("resultList.jsp"); 
 * } 
 * </pre> 
 * 
 * @author Takao Kouda
 * @version 1
 *
 */
public abstract class AbstractPageListGenerator extends CoreObject implements Serializable {
  	protected ParameterInputForm qf = null;
  	protected IRequestHandler rh = null;
  	protected IRequestParser rp = null;
  	
	/** 
	 * TuNXŃbZ[W擾邽߂MessageGenerator̃CX^X<br>
	 * IuWFNg{@link AppMessageGenerator }̃CX^X擾܂B
	 */
	protected MessageGenerator messageGenerator = null;  	
	/**
	 * RXgN^iȂ͔Jj
	 */  	
  	private AbstractPageListGenerator() { super(); }

	/**
	 * RXgN^
	 * 
	 * @param f ̓p[^l܂QueryInputForm
	 * @param rh IRequestHandler
	 * @throws Exception
	 */
  	public AbstractPageListGenerator(ParameterInputForm f, IRequestHandler rh)  {
  		this();
  		this.qf = f;
		this.rh = rh;
		this.rp = rh.getRequestParser();
		messageGenerator = AppMessageGenerator.getInstance();		
  	}
  	
  	/**
  	 * NXp҂Ăяo͒l̑Ó\bh<br>
  	 * ̃NX̗p҂͂̃\bhsA{@link #_validate()}s܂B
  	 * @return Óꍇtrue
  	 * @throws Exception
  	 */
	public boolean validate() throws Exception {
		trace("isValid", "entry");
		boolean b = _validate();
		trace("isValid", "exit");		
		return b;
	}

	/**
	 * ͒l̑Ó̎s܂B<br>
	 * ̃\bhabstractł͂܂Btrue߂܂BKvȏꍇɂ̃\bhI[o[Ch
	 * WbN܂B
	 * 
	 * @return Óꍇtrue
	 * @throws Exception
	 */
	protected boolean _validate() throws Exception {
		return true;
	}

	/**
	 * NXp҂ĂяoꗗIuWFNg擾\bh<br>
	 * NXp҂͂̃\bhsA{@link #_generate()}s܂B
	 * @return ʂ̈ꗗIuWFNg
	 * @throws Exception
	 */
	public final IPageList generate() throws Exception {
		trace("generate", "entry");
		IPageList p = _generate();
		trace("generate", "exit");		
		return p;
	}
	
	/**
	 * ꗗ`IuWFNg̎s܂B<br>
	 * ̃\bhabstractłBIPageListCX^X̎s܂B
	 * 
	 * @return ʂ̈ꗗIuWFNg
	 * @throws Exception
	 */
	protected abstract IPageList _generate() throws Exception;	
	
}
