package wisdomx.logic.formtemplate;

import java.util.*;
import javax.servlet.http.*;

import wisdom.core.Message;
import wisdom.core.MessageList;
import wisdom.core.application.IRequestParser;
import wisdom.core.request.ParameterNotFoundException;
import wisdomx.ui.object.*;
import wisdomx.ui.render.Tag;

/**
 * tB[h̖OƒlAbZ[WۊǂNXB<br>
 * Ɖʂł̓͒l̕ۊǂȂǂɎgp܂B
 *
 * @author  Takao Kouda
 * @version 1
 *
 */
public final class ParameterInputForm implements  IHasMessageList {
	
    /**
     * RXgN^
     *
     */
	public ParameterInputForm() { super(); }
	
	/**
	 * IRequestParserɊ܂܂p[^ׂĕۑ܂B<br>
	 * @param rp IRequestParser̃CX^X
	 */
	public void saveAll(IRequestParser rp) {
		HttpServletRequest req = rp.getRequest();
		for (Enumeration e = req.getParameterNames() ; e.hasMoreElements() ; ) {
			String key = (String)e.nextElement();
			String value = (String)req.getParameter(key);
			ht.put(key, value);
		}
	}
	/**
	 * tB[hAlǉ܂B<br>
	 * tB[hłɊ܂܂Ăꍇɂ͏㏑܂B
	 * @param	fieldName	ǉtB[h̖O
	 * @param	fieldValue	ǉtB[h̒l
	 */
	public void addString(String fieldName, String fieldValue) {
		ht.put(fieldName, fieldValue);		
	}

	/**
	 * tB[hAlǉ܂B<br>
	 * tB[hłɊ܂܂Ăꍇɂ͏㏑܂B
	 * @param	fieldName	ǉtB[h̖O
	 * @param	fieldValue	ǉtB[h̒l
	 */
	public void addObject(String fieldName, Object fieldValue) {
		ht.put(fieldName, fieldValue);		
	}
	/**
	 * w肳ꂽtB[hp[^擾ێ܂B
	 * @param rp IRequestParser̃CX^X
	 * @param fieldName 	ۑtB[h
	 * @exception ParameterNotFoundException YtB[h݂Ȃꍇ
	 */
	public void saveString(IRequestParser rp, String fieldName) throws ParameterNotFoundException {
		ht.put(fieldName, rp.getString(fieldName));
	}

	/**
	 * w肳ꂽtB[hp[^擾ێ܂B
	 * @param rp IRequestParser̃CX^X
	 * @param fieldName 	ۑtB[h
	 * @param def 	YtB[hꍇ̏ȗ̒l
	 */
	public void saveString(IRequestParser rp, String fieldName, String def)  {
		ht.put(fieldName, rp.getString(fieldName,def));
	}
	/**
	 * tB[hl擾܂B
	 * @param key 擾IuWFNg̃tB[hB
	 * @return ݂ȂꍇnullB
	 */
	public String getString(String key) {
		return (String)ht.get(key);
	}

	/**
	 * tB[hl擾܂B
	 * @param key 擾IuWFNg̃tB[hB
	 * @return ݂ȂꍇnullB
	 */
	public Object getObject(String key) {
		return ht.get(key);
	}

	/**
	 * w肵L[ŃIuWFNg擾܂B
	 * @param key 擾IuWFNg̃L[B
	 * @param	def	擾L[݂Ȃꍇ̏ȗl
	 * @return ݂ȂꍇdefB 
	 */
	public String getString(String key, String def) {
		String val = (String)ht.get(key);
		if (val == null) return def;
		return val;
	}
	
/* IHasMessageList̎ Jn */	

    public void addMessage(Message message) {
    	if (message == null ) return;
        messageList.addMessage(message);
    }
	public void addMessages(MessageList messages) {
		if (messages == null || messages.size() == 0) return;
		messageList.addMessages(messages);
	}    
    public void addErrorMessage(Message errorMessage) {
		if (errorMessage == null ) return;
        messageList.addMessage(errorMessage);
        error = true;
    }
	public void addErrorMessages(MessageList errorMessages) {
		if (errorMessages == null || errorMessages.size() == 0) return;
		messageList.addMessages(errorMessages);
		error = true;
	}

    public MessageList getMessageList() {
        return messageList;
    }
    
	public int messageSize() {
		return messageList.size();
	}

	public Message getMessage(int index) {
		return messageList.get(index);
	}

    public void clearMessageList() {
        messageList.clear();
        error = false;
    }

	public boolean containsMessageByFieldId(String field) {
		return messageList.contain(field);
	}	 

	public boolean isError() {
		return error;
	}
/* IHasMessageList̎ I*/	

	public String asString() {
		StringBuffer sb = new StringBuffer(getClass().getName());
		sb.append(" size=");
		sb.append(ht.size());
		sb.append(" \n");
		sb.append(ht.toString());
		return sb.toString();
	}

	public String toHidden() {
		StringBuffer sb = new StringBuffer();
		for (Iterator  keys = ht.keySet().iterator(); keys.hasNext();) {
			String key = (String)keys.next();
			String value = (String)ht.get(key);
			sb.append(Tag.hidden(key, value));
		}
		return sb.toString();
	} 

	public String toHidden(String fieldPrefix) {
		StringBuffer sb = new StringBuffer();
		for (Iterator  keys = ht.keySet().iterator(); keys.hasNext();) {
			String key = (String)keys.next();
			String value = (String)ht.get(key);
			sb.append(Tag.hidden(fieldPrefix+key, value));
		}
		return sb.toString();
	} 

	private HashMap ht = new HashMap();
	private boolean error = false;	
	private MessageList messageList = new MessageList();	

}
