package wisdomx.ui.builder;


import wisdom.core.application.IRequestHandler;
import wisdomx.ui.object.IOption;
import wisdomx.ui.object.Option;
import wisdomx.ui.object.Select;

/**
 * IOptionsBuilder̒ێNX<br>
 * ̃NXł́AIOption̒ǉĂ܂BIOption̒ǉ{@link #empty(int, Select)}\bhŎ
 * AftHg̎new Option("","")ǉĂ܂B<br>
 * 
 * @author  Takao Kouda
 * @version 1
 */
public abstract class AbstractOptionsBuilder implements IOptionsBuilder {
	/**
	 * {@link IRequestHandler }̃CX^XBTuNXŎgp܂B
	 */
	protected IRequestHandler rh = null;
	
	protected AbstractOptionsBuilder(IRequestHandler rh) {
		super();
		this.rh = rh;
	}
	
	public abstract Select build(int optionType, String optionsName) throws Exception;

	public abstract Select build(int optionType, String optionsName, String key) throws Exception;
	
	public abstract Select build(int optionType, String optionsName, String[] keys) throws Exception;
	

	public Select buildWithEmpty(int optionType, String optionsName) throws Exception {
		return replace(optionType, build(optionType, optionsName));
	}

	public Select buildWithEmpty(int optionType, String optionsName, String key) throws Exception{
		return replace(optionType, build(optionType, optionsName, key));		
	}
	
	public Select buildWithEmpty(int optionType, String optionsName, String[] keys) throws Exception{
		return replace(optionType, build(optionType, optionsName, keys));		
	}
	/**
	 * IOption߂lOptionsɒǉ܂B<br>
	 * ̃NX̎<br>
	 * return new Option("","");
	 * <br>
	 * łBCӂIOptionCX^X쐬߂ƂŁÃCX^XbuildWithEmpty\bh
	 * gp܂B<br>
	 * @param options
	 * @return ǉIOption
	 */
	protected IOption empty(int optionType, Select options) {
		return new Option("","");
	}
	private Select replace(int optionType, Select options) {
		Select option__ = new Select(options.getName());
		option__.add(empty(optionType, options));
		for (int i = 0 ; i < options.size() ; i++ ) {
			option__.add(options.get(i));
		}
		return option__;	
	}
}
