package wisdomx.ui.object;

import java.util.List;
import java.util.Vector;

import wisdom.core.util.StringUtil;

/**
 * {@link IOption }zŕێNX<br>
 * HTMLCheckboxASelect Multiplẽf[^EIuWFNgɎgp܂B<br>
 * ̃IuWFNg{@link wisdomx.ui.render.Tag }ɂĕ`悳܂BIuWFNg̏Ԑݒ
 * {@link wisdomx.ui.render.Tag }QƂĂB
 * 
 * @author Takao Kouda
 * @version 1
 * @see wisdomx.ui.render.Tag
 */
public class Checkbox extends Select {
	private List checkedOptionKeys  = null;
	private List disabledOptionKeys  = null;	
	
	/**
	 * RXgN^<br>
	 * 
	 * @param name Checkbox̖O
	 */
	public Checkbox(String name) {
		super(name);
		checkedOptionKeys = new Vector();
		disabledOptionKeys = new Vector();		
	}

	/**
	 * RXgN^<br>
	 *
	 * @param name Checkbox̖O
	 * @param options IOption̔z
	 */
	public Checkbox(String name, List options) {
		super(name, options);
		checkedOptionKeys = new Vector();
		disabledOptionKeys = new Vector();		
	}

	/**
	 * ̃IuWFNgɐݒ肳Ăname̒lݒ肵܂B
	 * @param name ݒ肷name
	 */	
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * CheckboxɑIԂ̃L[ݒ肵܂B<br>
	 * ̃\bhcheckedOptionKeyCheckboxIOptionɊ܂܂Ă邩̌<br>
	 * s܂BcheckedOptionKey̒lłɐݒ肳Ăꍇ͉s܂B
	 * 
	 * @param checkedOptionKey IԂɂL[
	 */
	public void setChecked(String checkedOptionKey) {
		if (!checkedOptionKeys.contains(checkedOptionKey)) checkedOptionKeys.add(checkedOptionKey);
	}

	/**
	 * CheckboxɑIԂ̃L[ݒ肵܂B<br>
	 * ̃\bhcheckedOptionKeysCheckboxIOptionɊ܂܂Ă邩̌<br>
	 * s܂BcheckedOptionKeys̒lłɐݒ肳Ăꍇ͉s܂B
	 * 
	 * @param checkedOptionKeys IԂɂL[̔zinull͖܂)
	 */
	public void setChecked(String[] checkedOptionKeys) {
		if (checkedOptionKeys == null) return;
		for (int i = 0 ; i < checkedOptionKeys.length ; i++) {
			if (!this.checkedOptionKeys.contains(checkedOptionKeys[i]) 
				&& StringUtil.notEmpty(checkedOptionKeys[i])) 
			this.checkedOptionKeys.add(checkedOptionKeys[i]);
		}
	}

	/**
	 * CheckboxɑIԂ̃L[܂B<br>
	 * ̃\bhuncheckedOptionKeyCheckboxIOptionɊ܂܂Ă邩̌<br>
	 * s܂B܂uncheckedOptionKey̒lCheckboxɑ΂đIς݂ɂȂĂȂꍇs܂B
	 * 
	 * @param uncheckedOptionKey IԂL[
	 */
	public void setUnchecked(String uncheckedOptionKey) {
		if (!checkedOptionKeys.contains(uncheckedOptionKey)) checkedOptionKeys.remove(uncheckedOptionKey);
	}

	/**
	 * CheckboxL[ׂđIԂɂ܂B<br>
	 * 
	 * @since 2004/5/14
	 */
	public void allChecked() {
		for (int i = 0 ; i < size(); i++) {
			if (!checkedOptionKeys.contains(get(i).getKey())) {
				checkedOptionKeys.add(get(i).getKey());
			}
		}
	}
	
	/**
	 * Checkbox̑IԂɂȂĂL[ׂăNA܂<br>
	 *
	 */
	public void clearChecked() {
		checkedOptionKeys.clear();
	}
	
	/**
	 * Checkbox̃L[𖳌ɂ܂B<br>
	 * ̃\bhɂĎw肳ꂽL[IOption{@link wisdomx.ui.render.Tag}CheckboxIuWFNg
	 * `悷ۂɖԂŕ\܂B
	 * 
	 * @param disabledOptionKey L[
	 */
	public void setDisabled(String disabledOptionKey) {
		if (!disabledOptionKeys.contains(disabledOptionKey)) disabledOptionKeys.add(disabledOptionKey);
	}
	/**
	 * Checkbox̃L[𖳌ɂ܂B<br>
	 * ̃\bhɂĎw肳ꂽL[IOption{@link wisdomx.ui.render.Tag}CheckboxIuWFNg
	 * `悷ۂɖԂŕ\܂B
	 * 
	 * @param disabledOptionKeys L[̔zinull͖܂j
	 */	
	public void setDisabled(String[] disabledOptionKeys) {
		if (disabledOptionKeys == null) return;
		for (int i = 0 ; i < disabledOptionKeys.length ; i++) {
			if (!this.disabledOptionKeys.contains(disabledOptionKeys[i]) 
				&& StringUtil.notEmpty(disabledOptionKeys[i])) 
			this.disabledOptionKeys.add(disabledOptionKeys[i]);
		}
	}
	/**
	 * Checkbox̃L[ׂĖɂ܂B<br>
	 * 
	 */
	public void allDisabled() {
		for(int i = 0; i < size() ; i++) {
			setDisabled(get(i).getKey());
		}		
	}	

	/**
	 * ɂȂĂCheckbox̃L[Lɂ܂B<br>
	 * 
	 * ̃\bhdisabledOptionKeyCheckboxIOptionɊ܂܂Ă邩̌<br>
	 * s܂B܂disabledOptionKey̒lCheckboxɑ΂ĖɂȂĂȂꍇs܂B
	 * 
	 * @param disabledOptionKey LɂL[
	 */
	public void clearDisabled(String disabledOptionKey) {
		if (!disabledOptionKeys.contains(disabledOptionKey)) disabledOptionKeys.remove(disabledOptionKey);
	}
	
	/**
	 * ɂȂĂCheckbox̃L[ׂėLɂ܂B<br>
	 * 
	 */	
	public void clearDisabled() {
		disabledOptionKeys.clear();
	}
	
	/**
	 * CheckboxIς݂ۂ܂B<br>
	 * @return ǂꂩЂƂłIς݂̏ꍇtrue
	 */
	public boolean isSelected() {
		return checkedOptionKeys.size() != 0;
	}	
	/**
	 * CheckboxIς݂ۂ܂B<br>
	 * @return Iς݂̏ꍇtrue
	 */
	public boolean isChecked() {
		return checkedOptionKeys.size() != 0;
	}
	/**
	 * w肳ꂽL[CheckboxőIς݂ۂ܂B<br>
	 * 
	 * @param checkedOptionKey L[
	 * @return IĂꍇtrue
	 */
	public boolean isChecked(String checkedOptionKey) {
		return checkedOptionKeys.contains(checkedOptionKey);
	}
	
	/**
	 * w肳ꂽL[CheckboxŖɂĂ݂ۂ܂B<br>
	 * 
	 * @param disabledOptionKey L[
	 * @return Ăꍇtrue
	 */
	public boolean isDisabled(String disabledOptionKey) {
		return disabledOptionKeys.contains(disabledOptionKey);
	}	
	
	/**
	 * Iς݂IOption̔zCheckboxIuWFNgŎ擾܂B<br>
	 * ߂CheckboxIuWFNgɂ͂CheckboxIuWFNgőIς݂ɂȂĂIOption̔z
	 * ܂CheckboxIuWFNgłB܂O͂CheckboxIuWFNg̖Ogp܂B<br>
	 * 
	 * @return Iς݂IOptionō쐬ꂽCheckbox
	 */
	public Checkbox getCheckedOptions() {
		Vector v = new Vector();
		for (int i = 0 ; i < size(); i++) {
			if (isChecked(get(i).getKey())) v.add(get(i));
		}	
		return new Checkbox(name, v);
	}
		
	/**
	 * ꂽIOption̔zCheckboxIuWFNgŎ擾܂B<br>
	 * ߂CheckboxIuWFNgɂ͂CheckboxIuWFNgŖꂽIOption̔z
	 * ܂CheckboxIuWFNgłB܂O͂CheckboxIuWFNg̖Ogp܂B<br>
	 * 
	 * @return ꂽIOptionō쐬ꂽCheckbox
	 */
	public Checkbox getDisabledOptions() {
		Vector v = new Vector();
		for (int i = 0 ; i < size(); i++) {
			if (isDisabled(get(i).getKey())) v.add(get(i));
		}	
		return new Checkbox(name, v);
	}	
}
