package wisdomx.ui.object;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import wisdom.core.util.StringUtil;

/**
 * {@link IOption}zŕێNX<br>
 * HTMLSelectARadiõf[^EIuWFNgɎgp܂B<br>
 * ̃NX͎gɖOtAIOption̒ǉA擾A폜sA܂IOptionɑ΂đIς݁A
 * Iς݂̉s܂B<br>
 * 
 * WA0033Ή 2004/11/18<br>
 * @author Takao Kouda
 * @version 1
 */
public class Select {
	
	protected List options = null;
	protected String name = null;
	protected String selectedOptionKey = null;
	protected boolean isDisabled = false;
	
	/**
	 * RXgN^<br>
	 */
	protected Select() {
		super();
	}
	/**
	 * RXgN^<br>
	 * @param name Selectɕt閼O
	 */
	public Select(String name) {
		this();
		this.options = new LinkedList();
		this.name = name;
		this.selectedOptionKey = "";
	}

	/**
	 * RXgN^<br>
	 * 
	 * @param name Selectɕt閼O
	 * @param options IOptioñCX^X܂񂾔z
	 */
	public Select(String name, List options) {
		this(name);
		this.options = options;
	}

	/**
	 * ̃IuWFNgɐݒ肳Ăname̒lݒ肵܂B
	 * @param name ݒ肷name
	 */	
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * IOptionǉ܂B<br>
	 * @param option ǉIOption
	 */
	public void add(IOption option) {
		options.add(option);
	}
	
	/**
	 * ێĂIOption̐擾܂B<br>
	 * 
	 * @return ێĂIOption̐
	 */
	public int size() {
		return options.size();
	}
	
	/**
	 * IꂽIOptioñL[NA܂<br>
	 *
	 */
	public void clearSelected() {
		selectedOptionKey = "";
	}
	
	/**
	 * Select̑IςݏԂIOptionkeyw肵܂B<br>
	 * 
	 * @param selectedOptionKey
	 */
	public void setSelected(String selectedOptionKey) {
		this.selectedOptionKey = selectedOptionKey;
	}
	
	/**
	 * Select̑IςݏԂIOptionkey擾܂B<br>
	 * @return IςݏԂIOptionkey
	 */
	public String getSelected() {
		return selectedOptionKey;
	}
	
	/**
	 * Select̑IςݏԂIOptionvalue擾܂B<br>
	 * @return IςݏԂIOptionvalue
	 */
	public String getSelectedValue() {
		//return get(selectedOptionKey).getValue();
		IOption ret = get(selectedOptionKey);
		if (ret == null) {
			return "";
		} else {
			return ret.getValue();
		}
	}	
	/**
	 * SelectIς݂ۂ܂B<br>
	 * @return Iς݂̏ꍇtrue
	 */
	public boolean isSelected() {
		return StringUtil.notEmpty(selectedOptionKey);
	}
	
	/**
	 * w肳ꂽindexIOption擾܂B<br>
	 * 
	 * @param index 擾index
	 * @return w肳ꂽindexIOption
	 */
	public IOption get(int index) { 
		return (IOption)options.get(index);
	}
	
	/**
	 * keyƓkeyIOption擾܂B<br>
	 * r{@link IOption#getKey()}.equals(key)ōs܂B
	 * @param key 
	 * @return w肳ꂽkeyƓkeyIOptionB݂Ȃꍇnull
	 */
	public IOption get(String key) {
		for (Iterator i = options.iterator() ; i != null && i.hasNext() ; )  {
			IOption x = (IOption)i.next();
			if (x.getKey().equals(key)) return x; 
		}
		return null;
	}
	
	/**
	 * ێĂIOptionListŎ擾܂B
	 * @return ێĂIOptionList
	 */
	public List getOptions() {	
		return options;
	}
	
	/**
	 * IOptionƓKeyIOptioñCfbNX擾܂B<br>
	 * r{@link IOption#getKey()}.equals(option.getKey())ōs܂B݂Ȃꍇ-1߂܂B
	 * @param option ʒu擾IOption
	 * @return 擾łCfbNXB݂Ȃꍇ-1
	 */
	public int indexOf(IOption option) {
		for (int i = 0 ; i < options.size() ; i++ )  {
			IOption x = (IOption)options.get(i);
			if (x.getKey().equals(option.getKey())) return i; 
		}
		return -1;
	}

	/**
	 * keyƓKeyIOptioñCfbNX擾܂B<br>
	 * r{@link IOption#getKey()}.equals(key)ōs܂B݂Ȃꍇ-1߂܂B
	 * @param key ʒu擾IOption
	 * @return 擾łCfbNXB݂Ȃꍇ-1
	 */		
	public int indexOf(String key) {
		for (int i = 0 ; i < options.size() ; i++ )  {
			IOption x = (IOption)options.get(i);
			if (x.getKey().equals(key)) return i; 
		}
		return -1;
	}
	
	/**
	 * Selectɐݒ肵O擾܂B<br>
	 * @return Selectɐݒ肵O
	 */
	public String getName() { 
		return name;
	}

	/**
	 * SelectgpsԂɂ܂B<br>
	 * WA0033Ή 2004/11/18
	 * @param disabled
	 */	
	public void setDisabled(boolean disabled) {
		this.isDisabled = disabled;
	}
	/**
	 * SelectgpsԂ܂B<br>
	 * WA0033Ή 2004/11/18
	 * @param disabled
	 */		
	public boolean isDisabled() {
		return this.isDisabled;
	}
}
