package wisdomx.ui.render;

/**
 * {@link IPageListDecorator }̃TvNX<br>
 * 
 * @author  Takao Kouda
 * @version 1
 */
public abstract class DefaultPageListDecorator implements IPageListDecorator {
	
	private String prevName = null;
	private String moveName = null;
	private String nextName = null;
	
	/**
	 * RXgN^<br>
	 * 
	 * ̃CxgJavaScript̃XNvg̖OɂȂ܂B<br>
	 * 
	 * @param prevName Oy[WɑJڂƂJavaScriptCxg
	 * @param moveName y[WʒuwőJڂƂJavaScriptCxg
	 * @param nextName Oy[WɑJڂƂJavaScriptCxg
	 */
	protected DefaultPageListDecorator(String prevName, String moveName, String nextName) {
		super();
		this.prevName = prevName;		
		this.moveName = moveName;
		this.nextName = nextName;		
	}
	
	public String drawCounter(int rows, int totalPage, int perPageRows, int currentPageIndex, boolean hasPrevious, boolean hasNext) {
		StringBuffer sb = new StringBuffer();
		if (rows == 0) return sb.toString();

		int i = (currentPageIndex / 10 );
		
		if (i != 0 && currentPageIndex > 10) {
				int pre = i*10;
				if ((currentPageIndex % 10 ) == 0) {
					pre -=10 ;
				}
				sb.append("<A HREF=\"javascript:")
					.append(prevName).append("('")
						.append(moveName).append("')\">")
							.append("<<").append("</A>")
								.append("&nbsp;&nbsp;");        		
		}
		if (i == 0) i = 1;
		else {
			if ((currentPageIndex % 10 ) !=0 ) i = i * 10 +1 ;
			else i = i * 10 - 9;				
		}
		int x = i + 10; 
        	
		for (;  i < x; i++) {
			if (i > totalPage) break;
			if (i != currentPageIndex) {
				sb.append("<A HREF=\"javascript:")
					.append(moveName).append("('")
						.append(i).append("')\">")
							.append(i).append("</A>")
								.append("&nbsp;&nbsp;");				
			} else {
				sb.append("<b>").append(i).append("</b>").append("&nbsp;&nbsp;");									
			}
		}
		if (i <=  totalPage) {
				sb.append("<A HREF=\"javascript:")
					.append(moveName).append("('")
						.append(i).append("')\">")
							.append(">>").append("</A>")
								.append("&nbsp;&nbsp;");        		
		}	
		return sb.toString();		
	}
	
	
	public String drawPrevious(boolean hasPrevioues) {
		if (!hasPrevioues) return "";
		return Tag.aHrefValueTitle("javascript:" + prevName+ "()","< Prev ","Oy[W");

	}
	
	public String drawNext(boolean hasNext) {
		if (!hasNext) return "";
		return Tag.aHrefValueTitle("javascript:" + nextName+ "()","Next >","y[W");
	}
	
	public int changePageIndex(String eventName, int currentPageIndex, int toPageIndex) {
		int i = 1;
		if (eventName.equals(prevName)) i = currentPageIndex -1;
		else if (eventName.equals(moveName)) i = toPageIndex;
		else if (eventName.equals(nextName)) i = currentPageIndex +1;
		return i;
	}
	
	public String getPrevEventName () {
		return prevName;
	}
	
	public String getMoveEventName ()  {
		return moveName;
	}

	public String getNextEventName () {
		return nextName;
	}
		
}
	