package wisdomx.ui.render;

import java.util.*;

import wisdomx.ui.object.IOption;
import wisdomx.ui.object.Select;

/**
 * SelectIuWFNg̕`NX<br>
 * WA0031Ή 2004/11/10<br>
 * WA0033Ή 2004/11/18<br>
 * @author  Takao Kouda
 * 
 * @version 1
 */
public class RSelect extends TagHelper {
	
	protected static String select(Select select){
		StringBuffer sb = new StringBuffer("<select");
		sb.append(" name=").append( quote(select.getName()));
		if ( select.isDisabled()) {
			sb.append(" disabled>\n");
		} else {
			sb.append(">\n");
		}
		sb.append(selectOption(select));
		sb.append("</select>\n");
		if (select.isDisabled()) {
			hiddenDisabled(select, sb);
		}
		return sb.toString();
	}
	protected static String selectClass(Select select, String clazz){
		StringBuffer sb = new StringBuffer("<select");
		sb.append(" name=").append( quote(select.getName()));
		sb.append(" class=").append( quote(clazz));
		if ( select.isDisabled()) {
			sb.append(" disabled>\n");
		} else {
			sb.append(">\n");
		}
		sb.append(selectOption(select));		
		sb.append("</select>\n");
		if (select.isDisabled()) {
			hiddenDisabled(select, sb);
		}
		return sb.toString();
	}	
	protected static String select(Select select, String onChangeEventName){
		StringBuffer sb = new StringBuffer("<select onChange=");
		sb.append(quote(onChangeEventName));
		sb.append(" name=").append( quote(select.getName()));

		if ( select.isDisabled()) {
			sb.append(" disabled>\n");
		} else {
			sb.append(">\n");
		}
		sb.append(selectOption(select));		
		sb.append("</select>\n");
		if (select.isDisabled()) {
			hiddenDisabled(select, sb);
		}
		return sb.toString();
	}
	protected static String selectClass(Select select, String onChangeEventName, String clazz){
		StringBuffer sb = new StringBuffer("<select onChange=");
		sb.append(quote(onChangeEventName));
		sb.append(" name=").append( quote(select.getName()));
		sb.append(" class=").append( quote(clazz));

		if ( select.isDisabled()) {
			sb.append(" disabled>\n");
		} else {
			sb.append(">\n");
		}
		sb.append(selectOption(select));
		sb.append("</select>\n");
		if (select.isDisabled()) {
			hiddenDisabled(select, sb);
		}
		return sb.toString();
	}	
	private static void hiddenDisabled(Select select, StringBuffer sb) {
		String key = select.getSelected();
		if (key != null) {
			IOption option = select.get(key);
			if (option != null) {
				sb.append(Tag.hidden(select.getName(),option.getKey()));
			} else {
				sb.append(Tag.hidden(select.getName(),""));
			}
		} else {
			sb.append(Tag.hidden(select.getName(),""));
		}
	}
	/* WA0031Ή 2004/11/10<br> */	
	private static String selectOption(Select select) {
		StringBuffer sb = new StringBuffer();
		String selectedValue = select.getSelected();		
		if (select != null) {
			for (int i = 0 ; i < select.size() ; i++ ) {
				IOption option = select.get(i);
				sb.append("<option");
				String s = option.getKey();
				sb.append(" value=").append( quote( escape2Input(s)  ));
				if (s != null && selectedValue != null && s.equals(selectedValue)) {
					sb.append("selected");
				}
				sb.append(">");
				sb.append( XTag.escape2Label(option.getValue()));
				sb.append("</option>\n");
			}
		}
		return sb.toString();
	}
	protected static String radio(Select select){
		String selectedValue = select.getSelected();
		StringBuffer sb = new StringBuffer();		
		if (select != null) {
			for (int i = 0 ; i < select.size() ; i++ ) {
				sb.append(radioOption(select, select.get(i), selectedValue,null)).append("\n");
			}
		}
		return sb.toString();
	}
	protected static String radio(Select select, String onClickEventName){
		String selectedValue = select.getSelected();
		StringBuffer sb = new StringBuffer();		
		if (select != null) {
			for (int i = 0 ; i < select.size() ; i++ ) {
				sb.append(radioOption(select, select.get(i), selectedValue,onClickEventName)).append("\n");
			}
		}
		return sb.toString();
	}	
	protected static List radioList(Select select){
		String selectedValue = select.getSelected();
		List l = new Vector();
		if (select != null) {
			for (int i = 0 ; i < select.size() ; i++ ) {
				l.add(radioOption(select, select.get(i), selectedValue,null));
			}
		}
		return l;
	}
	protected static List radioList(Select select, String onClickEventName){
		String selectedValue = select.getSelected();
		List l = new Vector();
		if (select != null) {
			for (int i = 0 ; i < select.size() ; i++ ) {
				l.add(radioOption(select, select.get(i), selectedValue, onClickEventName));
			}
		}
		return l;
	}	
	private static String radioOption(Select select, IOption option, String selectedValue, String onClickEventName) {
		StringBuffer sb = new StringBuffer();
		sb.append("<input type=").append(quote("radio"));
		sb.append(" name=").append(quote(select.getName()));
		if (onClickEventName != null) sb.append(" onClick=").append( quote( onClickEventName ));
		String s = option.getKey();
		sb.append(" value=").append( quote( s ));
		if (s != null && selectedValue != null && s.equals(selectedValue)) {
			sb.append(" checked");
		}
		sb.append(">");
		sb.append(option.getValue());		
		return sb.toString();		
	}
	
	
}

		