package wisdomx.ui.render;

import java.util.*;

import wisdom.core.CoreMessageGenerator;
import wisdom.core.CoreRuntimeException;
import wisdomx.logic.formtemplate.Define;
import wisdomx.ui.object.Checkbox;
import wisdomx.ui.object.PageListRow;
import wisdomx.ui.object.Select;

/**
 * wisdomx.ui.objectpbP[W̃NXHTML\ɕɕϊNX<br>
 * 
 * ̃NXł́A\Aׂ͕͂ăGXP[vs܂B<br>
 * \bhsɈ̃IuWFNgnull̏ꍇA{@link wisdom.core.CoreRuntimeException }oꍇ܂B<br>
 * 
 * WA0031Ή 2004/11/10<br>
 * WA0032Ή 2004/11/17<br>
 * @author  Takao Kouda
 * @version 1
 */
public class Tag extends TagHelper {

	/**
	 * HTML̕\pɃGXP[v쐬܂B<br>
	 *  
	 * @param value GXP[v镶
	 * @return GXP[vꂽ
	 */
	public static final String escape2Label(String value) {
		if (value == null) return "";
		return escape2Label(value.toString(),LF_);
	}
	
	/**
	 * \p̕쐬܂B<br>
	 * ̕HTML\pɃGXP[v쐬܂B<br>
	 * 
	 * @param string \p̕
	 * @return \p̕
	 */
	public static String label(String string) {
		if (string == null) throwExcpetion("label");
		return escape2Label(string);
	}

	/**
	 * \p̕쐬܂B<br>
	 * define{@link Define#getLabel()}HTML\pɃGXP[v쐬܂B<br>
	 * 
	 * @param define \DefineIuWFNg
	 * @return \p̕
	 * @since 2004/3/15
	 */
	public static String label(Define define) {
		if (define == null) throwExcpetion("label");
		return escape2Label(define.getLabel());
	}
				

	/**
	 * INPUT^OString쐬܂B<br>
	 * ^Ȍɂ͈ȉgpAl̓GXP[vꂽlł<br><br>
	 * 
	 * size="define.getLength()* 1.2"<br>
	 * maxlength="define.getLength()"<br>
	 * name="define().getId()"<br>
	 * value="string"<br>
	 * 
	 * @param define 
	 * @return INPUT^OString
	 */
	public static String input(Define define, String string) {
		if (define == null) throwExcpetion("input");
		StringBuffer sb = new StringBuffer("<input");
		sb.append(" type=").append( quote( "text" ));		
		sb.append(" size=").append( quote( (define.getLengh() * 1.2) ));
		sb.append(" maxlength=").append( quote(define.getLengh()));
		sb.append(" name=").append( quote(define.getId().toLowerCase()));
		sb.append(" value=").append( quote(escape2Input(string)));	
		sb.append(">");
		return sb.toString();
	}
	
	/**
	 * FILE^OString쐬܂B<br>
	 * ^Ȍɂ͈ȉgp܂<br><br>
	 * 
	 * name="define.getId()"<br>
	 * 
	 * @param define 
	 * @return FILE^OString
	 */
	public static String file(Define define) {
		if (define == null) throwExcpetion("file");

		StringBuffer sb = new StringBuffer("<input");
		sb.append(" type=").append( quote( "file" ));		
		sb.append(" name=").append( quote(define.getId().toLowerCase()));
		sb.append(">");
		return sb.toString();
	}	
	/**
	 * A^O쐬܂B<br>
	 * ߂l<br>
	 * &lt;a href="href"&gt;value&lt;/a&gt;
	 * <br>łB
	 * @param href
	 * @param value
	 * @return A^O
	 */
	public static final String aHrefValue(String href, String value) {
		if (href == null || value == null) throwExcpetion("aHrefValue");
		
		return 
		new StringBuffer("<a ")
		.append(attribute("href",href))
		.append(">")
		.append(escape2Label( value )).append("</a>")
		.toString();
	}
	
	/**
	 * A^O쐬܂B<br>
	 * ߂l<br>
	 * &lt;a href="href" target="target"&gt;value&lt;/a&gt;
	 * </br>łB
	 * @param href
	 * @param value
	 * @param target
	 * @return A^O
	 */
	public static final String aHrefValueTarget(String href, String value, String target) {
		if (href == null || value == null || target == null) throwExcpetion("aHrefValueTarget");
		
		return 
		new StringBuffer("<a ")
		.append(attribute("href",href))
		.append(" ")
		.append(attribute("target",target))
		.append(">")
		.append(escape2Label(value)).append("</a>")
		.toString();
	}

	/**
	 * A^O쐬܂B<br>
	 * ߂l<br>
	 * &lt;a href="href" title="title"&gt;value&lt;/a&gt;
	 * <br>łB
	 * @param href
	 * @param value
	 * @param title
	 * @return A^O
	 */
	public static final String aHrefValueTitle(String href, String value, String title) {
		if (href == null || value == null || title == null) throwExcpetion("aHrefValueTitle");
		
		return 
		new StringBuffer("<a ")
		.append(attribute("href",href))
		.append(" ")
		.append(attribute("title",escape2Label(title)))
		.append(">")
		.append(escape2Label(value)).append("</a>")
		.toString();
	}
	
	/**
	 * A^O쐬܂B<br>
	 * ߂l<br>
	 * &lt;a href="href" title="title" class="clazz"&gt;value&lt;/a&gt;
	 * <br>łB
	 * @param href
	 * @param value
	 * @param clazz
	 * @return A^O
	 */
	public static final String aHrefValueTitleClass(String href, String value, String title, String clazz) {
		if (href == null || value == null || title == null || clazz == null) throwExcpetion("aHrefValueTitleClass");
		
		return 
		new StringBuffer("<a ")
		.append(attribute("href",href))
		.append(" ")
		.append(attribute("class",clazz))
		.append(">")
		.append(escape2Label(value)).append("</a>")
		.toString();
	}
	/**
	 * A^O쐬܂B<br>
	 * ߂l<br>
	 * &lt;a href="href" title="title" target="target"&gt;value&lt;/a&gt;
	 * <br>łB
	 * @param href
	 * @param value
	 * @param title
	 * @param target
	 * @return A^O
	 */
	public static final String aHrefValueTitleTarget(String href, String value, String title, String target) {
		if (href == null || value == null || title == null || target == null) throwExcpetion("aHrefValueTitleTarget");
		
		return 
		new StringBuffer("<a ")
		.append(attribute("href",href))
		.append(" ")
		.append(attribute("title",escape2Label(title) ))
		.append(" ")
		.append(attribute("target",target))
		.append(">")
		.append(escape2Label( value )).append("</a>")
		.toString();
	}
	/**
	 * A^O쐬܂B<br>
	 * ߂l<br>
	 * &lt;a href="href" title="title" target="target" class="clazz"&gt;value&lt;/a&gt;
	 * <br>łB
	 * @param href
	 * @param value
	 * @param title
	 * @param target
	 * @param clazz
	 * @return A^O
	 */
	public static final String aHrefValueTitleTargetClass(String href, String value, 
							String title, String target, String clazz) {
								
		if (href == null || value == null || title == null || target == null || clazz == null) 
			throwExcpetion("aHrefValueTitleTargetClass");
										
		return 
		new StringBuffer("<a ")
		.append(attribute("href",href))
		.append(" ")
		.append(attribute("title",escape2Label( title )))
		.append(" ")
		.append(attribute("target",target))
		.append(" ")
		.append(attribute("class",clazz))
		.append(">")
		.append(escape2Label(value)).append("</a>")
		.toString();
	}

	
		
	/**
	 * HIDDEN^OString쐬܂B<br>
	 * 
	 * 2004/6/7 c<br>
	 * tB[h̒l̒uŋ󔒕̏ꍇ̒up~܂B
	 * @param fieldName
	 * @param fieldValue
	 * @return HIDDEN^OString
	 * 
	 */	
	public static String hidden(String fieldName, String fieldValue){
		StringBuffer sb = new StringBuffer("<input");
		sb.append(" type=").append( quote( "hidden" ));		
		sb.append(" name=").append( quote(fieldName));
		
		
		/* sb.append(" value=").append( quote(escape2Label(fieldValue)));	2004/6/7 	폜 */
		sb.append(" value=").append( quote(escape2Input(fieldValue)));		/* 2004/6/7 ύX */
		sb.append(">");
		return sb.toString();
	}

	/**
	 * CHECKBOX^OString쐬܂B<br>
	 * 
	 * @param checkbox
	 * @return CHECKBOX^OString
	 */
	public static String checkbox(Checkbox checkbox) {
		if (checkbox == null) throwExcpetion("checkbox");
		
		return RCheckbox.checkbox(checkbox);
	}
	
	/**
	 * CHECKBOX^OString쐬܂B<br>
	 * WA0032Ή 2004/11/17<br>
	 * @param checkbox
	 * @param clazz
	 * @return CHECKBOX^OString
	 * @since  2004/11/17
	 */
	public static String checkboxClass(Checkbox checkbox, String clazz) {
		if (checkbox == null) throwExcpetion("checkbox");
		
		return RCheckbox.checkboxClass(checkbox,clazz);
	}
		
	/**
	 * CHECKBOX^OString܂List쐬܂B<br>
	 * 
	 * @param checkbox
	 * @return CHECKBOX^OString܂List
	 */
	public static List checkboxList(Checkbox checkbox) {
		if (checkbox == null) throwExcpetion("checkboxList");
		
		return RCheckbox.checkboxList(checkbox);
	}
	
	/**
	 * CheckboxŖɐݒ肳ĂL[HIDDEN^OString쐬܂B
	 * CHECKBOX^OdisabledĂꍇA͒lƂ邱ƂłȂ̂HIDDEN^O
	 * \ĂKv܂B<br>
	 * @param checkbox
	 * @return CheckboxŖɐݒ肳ĂL[HIDDEN^OString
	 */	
	public static String checkboxDisables(Checkbox checkbox) {
		if (checkbox == null) throwExcpetion("checkboxDisables");
		
		return RCheckbox.checkboxDisables(checkbox);
	}
	
	/**
	 * SELECT MULTIPLE^OString쐬܂B<br>
	 * WA0031Ή 2004/11/10<br>  
	 * @param checkbox
	 * @param size
	 * @return SELECT MULTIPLE^OString
	 */
	public static String selectMultiple(Checkbox checkbox, int size) {
		if (checkbox == null) throwExcpetion("selectMultiple");
		
		return RCheckbox.selectMultipule(checkbox,size);
	}
	/**
	 * SELECT^OString쐬܂B<br>
	 * WA0031Ή 2004/11/10<br>
	 * @param select
	 * @return SELECT^OString
	 */
	public static String select(Select select){
		if (select == null) throwExcpetion("select");
		return RSelect.select(select);
	}
	/**
	 * SELECT^OString쐬܂B<br>
	 * WA0031Ή 2004/11/10<br>
	 * @param select
	 * @param clazz 
	 * @return SELECT^OString
	 */
	public static String selectClass(Select select, String clazz){
		if (select == null || clazz == null) throwExcpetion("select");
		
		return RSelect.selectClass(select, clazz);
	}	
	/**
	 * SELECT^OString쐬܂B<br>
	 * ̃\bh͏o͂HTML^OJavaScriptonChangeEventǉ܂B<br>
	 * WA0031Ή 2004/11/10<br>
	 * @param select
	 * @param onChangeEventName 
	 * @return SELECT^OString
	 */	
	public static String select(Select select, String onChangeEventName){
		if (select == null || onChangeEventName == null) throwExcpetion("checkbox");
		return RSelect.select(select, onChangeEventName);
	} 
	/**
	 * SELECT^OString쐬܂B<br>
	 * ̃\bh͏o͂HTML^OJavaScriptonChangeEventǉ܂B<br>
	 * WA0031Ή 2004/11/10<br>
	 * @param select
	 * @param onChangeEventName 
	 * @param clazz
	 * @return SELECT^OString
	 */	
	public static String selectClass(Select select, String onChangeEventName, String clazz){
		if (select == null || onChangeEventName == null || clazz == null) throwExcpetion("checkbox");
		return RSelect.selectClass(select, onChangeEventName, clazz);
	} 	
	/**
	 * RADIO^OString쐬܂B<br>
	 * 
	 * @param select
	 * @return RADIO^OString
	 */
	public static String radio(Select select){
		if (select == null) throwExcpetion("radio");
		
		return RSelect.radio(select);
	}	
	/**
	 * RADIO^OString쐬܂B<br>
	 * ̃\bh͏o͂HTML^OJavaScriptonClickEventǉ܂B<br>
	 * 
	 * @param select
	 * @param onClickEventName
	 * @return RADIO^OString
	 */
	public static String radio(Select select, String onClickEventName){
		if (select == null || onClickEventName == null) throwExcpetion("radio");
		
		return RSelect.radio(select, onClickEventName);
	}

	/**
	 * RADIO^OString܂List쐬܂B<br>
	 * 
	 * @param select
	 * @return RADIO^OString܂List
	 */	
	public static List radioList(Select select){
		if (select == null) throwExcpetion("radioList");
		
		return RSelect.radioList(select);
	}
	/**
	 * CHECKBOX^OȂǂŎgp"checked"Ƃ쐬܂B<br>
	 * 
	 * @param checked
	 * @return checked^̏ꍇ"checked"AȔꍇ""
	 */
	public static String isChecked(boolean checked) {
		if (checked) return " checked ";
		return "";
	}
	/**
	 * CHECKBOX^OȂǂŎgp"checked"Ƃ쐬܂B<br>
	 * {@link PageListRow }{@link PageListRow#isCheck()}̖߂lgpČs܂B<br>
	 * 
	 * @param row
	 * @return {@link PageListRow#isCheck()}^̏ꍇ"checked"AȔꍇ""
	 */
	public static String isChecked(PageListRow row) {
		if (row.isCheck()) return " checked ";
		return "";
	}	
	/**
	 * CHECKBOX^OȂǂŎgp"checked"Ƃ쐬܂B<br>
	 * 
	 * @param checked
	 * @return checked.equals("on")^̏ꍇ"checked"AȔꍇ""
	 */
	public static String isChecked(String checked) {
		if (checked.equals("on")) return " checked ";
		return "";
	}	
	/**
	 * RADIO^OString܂List쐬܂B<br>
	 * ̃\bh͏o͂HTML^OJavaScriptonClickEventǉ܂B<br>
	 * @param select
	 * @param onClickEventName
	 * @return RADIO^OString܂List
	 */		
	public static List radioList(Select select, String onClickEventName){
		if (select == null || onClickEventName == null) throwExcpetion("radioList");

		return RSelect.radioList(select, onClickEventName);
	} 
	private static void throwExcpetion(String methodName) {
		throw new CoreRuntimeException(
			CoreMessageGenerator.getInstance().getMessage("WRE1000", Tag.class.getName(), methodName)
		);
	}
}

		