package wisdomx.ui.render;

import wisdom.core.util.StringUtil;
import wisdomx.logic.formtemplate.Types;

/**
 * HTMLGXP[vString𐶐NXB<br> 
 * 
 * WA0042Ή 2006/4/22<br>
 * @author  Takao Kouda
 * @version 1
 */
public class TagHelper implements Types {
	protected static final char LT = '<';
	protected static final char GT = '>';	
	protected static final char AMP = '&';
	protected static final char QUOTE = '"';
	protected static final char SPACE = ' ';
	protected static final char LF = '\n';
				
	protected static final String LT_ = "&lt;";
	protected static final String GT_ = "&gt;";
	protected static final String AMP_ = "&amp;";
	protected static final String QUOTE_ = "&quot;";
	protected static final String SPACE_ = "&nbsp;";
	protected static final String LF_ = "<br>";
	protected static final String XLF_ = "<br />";	
	
	/**
	 * INPUT^OpɃGXP[v쐬܂B<br>
	 * 
	 * @param value GXP[v镶
	 * @return GXP[vꂽ
	 */
	public static String escape2Input(String value) {
		if (value == null) return "";
		return escape2Input_(value.toString());
	}


	private static String escape2Input_(String source) {
		StringBuffer sb = new StringBuffer(source.length());
		int length = source.length();
		for( int i = 0; i < length ; i++ ) {
			char ch = source.charAt(i);
			if( ch == LT ) sb.append(LT_);
			else if( ch == GT ) sb.append(GT_);
			else if( ch == AMP ) sb.append(AMP_);
			else if( ch == QUOTE ) sb.append(QUOTE_);
			else sb.append( ch );
		}
		return sb.toString();		
	}

	protected static String escape2Label(String value, String br) {
		if (value == null) return "";
		String source = value.toString();
		
		source = StringUtil.replace(source, "\r\n","\n");		
		source = StringUtil.replace(source, "\r","\n");        
		StringBuffer sb = new StringBuffer(source.length());
		int length = source.length();

		for( int i = 0; i < length ; i++ ) {
			char ch = source.charAt(i);
			if( ch == LT ) sb.append(LT_);
			else if( ch == GT ) sb.append(GT_);
			else if( ch == AMP ) sb.append(AMP_);
			else if( ch == QUOTE ) sb.append(QUOTE_);
			else if( ch == SPACE ) sb.append(SPACE_);                                    
			else if( ch == LF ) sb.append(br);            
			else sb.append( ch );
		}
		return sb.toString();
	}
		
	public static String quote(String value) {
		return "\"" +  value +"\"";
	}
	public static String quote(double value) {
		int value_ = (int)value;
		return quote(String.valueOf(value_));
	}	
	public static String attribute(String name, String value) {
		return new StringBuffer(name).append("=").append(quote(value )).toString();
	}
}

		