/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.util.regex.Pattern;

/**
 * {@link DomContext#getId()}を正規表現で照合した結果を返す{@link Evaluable}。
 * @author nakamura
 *
 */
public class EvalIdRegExp implements Evaluable<Boolean> {
	private final Pattern pattern;
	
	/**
	 * コンストラクタ。
	 * @param pattern 正規表現。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public EvalIdRegExp(final Pattern pattern){
		pattern.getClass();
		this.pattern = pattern;
	}

	/**
	 * コンストラクタ。
	 * @param pattern 正規表現。
	 * @throws NullPointerException 引数が null の場合。
	 * @throws PatternSyntaxException 表現の構文が無効である場合。
	 */
	public EvalIdRegExp(final String pattern){
		this(Pattern.compile(pattern));
	}

	public Boolean eval(final DomContext context) {
		return pattern.matcher(context.getId()).matches();
	}
}
