/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;


/**
 * 値取得/格納と作用のための式言語を表す インタープリタ デザインパターンの Expression 役。
 * 実装クラスの各インスタンスはステートレスであるべき。
 * @author nakamura
 *
 */
public interface EL extends GettingEL {
	
	/**
	 * 基点に対し言語を作用させ、値を設定する。
	 * @param root 基点。
	 * @param value 実行結果の値。
	 * @throws ELTargetRuntimeException 呼び出し先メソッドがエラーを投げた場合。
	 */
	public void setValue(Object root, Object value) throws ELTargetRuntimeException;
}
