/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.util.Collection;
import java.util.Collections;

/**
 * 固定値を返す{@link Switchable}。
 * @author nakamura
 *
 * @param <K>
 * @param <V>
 */
public class FixSwitch<K,V> implements Switchable<K,V> {
	private final V v;
	
	/**
	 * コンストラクタ。
	 * @param v 固定値。
	 */
	public FixSwitch(final V v){
		this.v = v;
	}

	public V get(final K key) {
		return v;
	}

	public Collection<K> keys() {
		return Collections.emptySet();
	}

	public V getDefault() {
		return v;
	}
}
