/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.util.Collection;

import woolpack.utils.UtilsConstants;

/**
 * 値が集合に含まれることを検証してその結果を返す{@link ValidatorExpression}。
 * {@link ValidatorContext}に対して状態を変更する操作を行わない。
 * @author nakamura
 *
 */
public class ValidValuesValidator extends ValidCollectionValidator {
	
	/**
	 * コンストラクタ。
	 * @param validCollection 妥当な値の集合。本クラスはこの引数の状態を変化させない。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public ValidValuesValidator(final Collection<String> validCollection){
		super(validCollection);
	}

	/**
	 * @throws NullPointerException 引数または{@link ValidatorContext#getInputMap()}が null の場合。
	 */
	@Override
	public Collection getCollection(final ValidatorContext context) {
		return UtilsConstants.toCollection(context.getTmpValue());
	}
}
