/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.config;

import junit.framework.TestCase;

public class CopyConfigContextTest extends TestCase {
	
	public void testNormal(){
		final ConfigCount counter = new ConfigCount(ConfigConstants.NULL);
		final ConfigExpression expression = new CopyConfigContext(counter);
		final ConfigContext context = new ConfigContext();
		ConfigConstants.MAKE_MAP.interpret(context);
		expression.interpret(context);
		assertEquals(1, counter.getCount());
		assertEquals(context.getMap(), counter.getContextList().getLast().getMap());
		assertTrue(context.getMap() != counter.getContextList().getLast());
	}
}
