/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import woolpack.el.ELConstants;
import junit.framework.TestCase;

public class EvalNetMaskTest extends TestCase {

	public void testConstructor(){
		try{
			new EvalNetMask(null, "255.255.255.0");
		}catch(final NullPointerException e){
		}
		try{
			new EvalNetMask(ELConstants.NULL, null);
		}catch(final NullPointerException e){
		}
		try{
			new EvalNetMask(ELConstants.NULL, "");
		}catch(final IllegalArgumentException e){
		}
		try{
			new EvalNetMask(ELConstants.NULL, "255.255.255,0");
		}catch(final IllegalArgumentException e){
		}
	}
	
	public void testNormal(){
		{
			final Evaluable<String> eval = new EvalNetMask("255.255.255.0");
			final DomContext context = new DomContext();
			assertEquals(null, eval.eval(context));
			context.getLocal().put("woolpack.dom.NET_MASK", "192.168.0.1");
			assertEquals("192.168.0.0", eval.eval(context));
			context.getLocal().put("woolpack.dom.NET_MASK", "192.168.1.2");
			assertEquals("192.168.1.0", eval.eval(context));
			context.getLocal().put("woolpack.dom.NET_MASK", "192.168.255.3");
			assertEquals("192.168.255.0", eval.eval(context));
		}
		{
			final Evaluable<String> eval = new EvalNetMask("255.255.240.0");
			final DomContext context = new DomContext();
			assertEquals(null, eval.eval(context));
			context.getLocal().put("woolpack.dom.NET_MASK", "192.168.0.1");
			assertEquals("192.168.0.0", eval.eval(context));
			context.getLocal().put("woolpack.dom.NET_MASK", "192.168.15.2");
			assertEquals("192.168.0.0", eval.eval(context));
			context.getLocal().put("woolpack.dom.NET_MASK", "192.168.16.3");
			assertEquals("192.168.16.0", eval.eval(context));
			context.getLocal().put("woolpack.dom.NET_MASK", "192.168.255.4");
			assertEquals("192.168.240.0", eval.eval(context));
		}
	}
}
