/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;
import woolpack.utils.MapBuilder;

public class ArrayPathELTest extends TestCase {

	public void testConstructor(){
		try{
			new ArrayPathEL((EL[])null);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new ArrayPathEL((Collection<EL>)null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormalMap(){
		final Map<String,Object> map = MapBuilder.get(new HashMap<String,Object>())
		.put("key0", 
				MapBuilder.get(new HashMap<String,Object>())
				.put("key1", new Integer(3))
				.get())
		.get();
		
		final EL el = new ArrayPathEL(new MapEL("key0"), new MapEL("key1"));
		
		assertEquals(new Integer(3), el.getValue(map));
		assertEquals("3", el.getValue(map, String.class));
		
		el.setValue(map, "valuee01a");
		assertEquals("valuee01a", el.getValue(map));
	}
	
	public void testEquals(){
		{
			final EL obj = new ArrayPathEL(new MapEL("key0"), new MapEL("key1"));
			assertTrue(obj.equals(obj));
		}
		assertTrue(new ArrayPathEL(new MapEL("key0"), new MapEL("key1")).equals(new ArrayPathEL(new MapEL("key0"), new MapEL("key1"))));
		assertFalse(new ArrayPathEL(new MapEL("key0"), new MapEL("key1")).equals(new ArrayPathEL(new MapEL("key0"), new MapEL("key2"))));
		assertFalse(new ArrayPathEL(new MapEL("key2"), new MapEL("key1")).equals(new ArrayPathEL(new MapEL("key0"), new MapEL("key1"))));
		assertFalse(new ArrayPathEL(new MapEL("key0"), new MapEL("key1")).equals(new Object()));
		assertFalse(new ArrayPathEL(new MapEL("key0"), new MapEL("key1")).equals(null));
	}
	
	public void testHashCode(){
		assertTrue(new ArrayPathEL(new MapEL("key0"), new MapEL("key1")).hashCode() == new ArrayPathEL(new MapEL("key0"), new MapEL("key1")).hashCode());
		assertTrue(new ArrayPathEL(new MapEL("key0"), new MapEL("key1")).hashCode() != new ArrayPathEL(new MapEL("key0"), new MapEL("key2")).hashCode());
		assertTrue(new ArrayPathEL(new MapEL("key0"), new MapEL("key1")).hashCode() != new ArrayPathEL(new MapEL("key2"), new MapEL("key1")).hashCode());
	}
	
	public void testToString(){
		assertEquals(
				"woolpack.el.ArrayPathEL@@[getting={woolpack.el.MapEL@@[key=key0,convertEL=woolpack.el.CollectionTypeConvertEL@@[convertEL=woolpack.el.SimpleTypeConvertEL@@]]},setting=woolpack.el.MapEL@@[key=key1,convertEL=woolpack.el.CollectionTypeConvertEL@@[convertEL=woolpack.el.SimpleTypeConvertEL@@]]]", 
				new ArrayPathEL(new MapEL("key0"), new MapEL("key1")).toString().replaceAll("@[a-z0-9]+", "@@"));
	}
}
