/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import java.util.Arrays;
import java.util.Collection;

import woolpack.TestUtils;

import junit.framework.TestCase;

public class CollectionConvertELTest extends TestCase {

	public void testConstructor(){
		try{
			new CollectionTypeConvertEL(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal(){
		assertTrue(TestUtils.equals("1", ELConstants.COLLECTION_CONVERTER.getValue("1", Object.class)));
		assertTrue(TestUtils.equals(new Integer(1), ELConstants.COLLECTION_CONVERTER.getValue("1", Integer.class)));
		assertTrue(TestUtils.equals(new int[]{1}, ELConstants.COLLECTION_CONVERTER.getValue("1", int[].class)));
		assertTrue(TestUtils.equals(new Integer[]{new Integer(1)}, ELConstants.COLLECTION_CONVERTER.getValue("1", Integer[].class)));
		assertTrue(TestUtils.equals(Arrays.asList("1"), ELConstants.COLLECTION_CONVERTER.getValue("1", Collection.class)));

		assertTrue(TestUtils.equals(new String[]{"1"}, ELConstants.COLLECTION_CONVERTER.getValue(new String[]{"1"}, Object.class)));
		assertTrue(TestUtils.equals(new Integer(1), ELConstants.COLLECTION_CONVERTER.getValue(new String[]{"1"}, Integer.class)));
		assertTrue(TestUtils.equals(new int[]{1}, ELConstants.COLLECTION_CONVERTER.getValue(new String[]{"1"}, int[].class)));
		assertTrue(TestUtils.equals(new Integer[]{new Integer(1)}, ELConstants.COLLECTION_CONVERTER.getValue(new String[]{"1"}, Integer[].class)));
		assertTrue(TestUtils.equals(Arrays.asList("1"), ELConstants.COLLECTION_CONVERTER.getValue(new String[]{"1"}, Collection.class)));

		assertTrue(TestUtils.equals(Arrays.asList("1"), ELConstants.COLLECTION_CONVERTER.getValue(Arrays.asList("1"), Object.class)));
		assertTrue(TestUtils.equals(new Integer(1), ELConstants.COLLECTION_CONVERTER.getValue(Arrays.asList("1"), Integer.class)));
		assertTrue(TestUtils.equals(new int[]{1}, ELConstants.COLLECTION_CONVERTER.getValue(Arrays.asList("1"), int[].class)));
		assertTrue(TestUtils.equals(new Integer[]{new Integer(1)}, ELConstants.COLLECTION_CONVERTER.getValue(Arrays.asList("1"), Integer[].class)));
		assertTrue(TestUtils.equals(Arrays.asList("1"), ELConstants.COLLECTION_CONVERTER.getValue(Arrays.asList("1"), Collection.class)));
		
		assertNull(ELConstants.COLLECTION_CONVERTER.getValue(null, Object.class));
		assertNull(ELConstants.COLLECTION_CONVERTER.getValue(null, Integer.class));
		try{
			ELConstants.COLLECTION_CONVERTER.getValue(null, int[].class);
			fail();
		}catch(final IllegalArgumentException e){
		}
		assertTrue(TestUtils.equals(new Integer[]{null}, ELConstants.COLLECTION_CONVERTER.getValue(null, Integer[].class)));
		assertTrue(TestUtils.equals(Arrays.asList((Object)null), ELConstants.COLLECTION_CONVERTER.getValue(null, Collection.class)));

	}
	
	public void testEquals(){
		{
			final CollectionTypeConvertEL obj = new CollectionTypeConvertEL(ELConstants.SIMPLE_CONVERTER);
			assertTrue(obj.equals(obj));
		}
		assertTrue(
				new CollectionTypeConvertEL(ELConstants.SIMPLE_CONVERTER)
				.equals(new CollectionTypeConvertEL(ELConstants.SIMPLE_CONVERTER)));
		assertFalse(
				new CollectionTypeConvertEL(ELConstants.SIMPLE_CONVERTER)
				.equals(new CollectionTypeConvertEL(ELConstants.COLLECTION_CONVERTER)));
		assertFalse(new CollectionTypeConvertEL(ELConstants.SIMPLE_CONVERTER).equals(new Object()));
		assertFalse(new CollectionTypeConvertEL(ELConstants.SIMPLE_CONVERTER).equals(null));
	}
	
	public void testHashCode(){
		assertTrue(
				new CollectionTypeConvertEL(ELConstants.SIMPLE_CONVERTER).hashCode() ==  
					new CollectionTypeConvertEL(ELConstants.SIMPLE_CONVERTER).hashCode());
		assertTrue(
				new CollectionTypeConvertEL(ELConstants.SIMPLE_CONVERTER).hashCode() !=  
					new CollectionTypeConvertEL(ELConstants.COLLECTION_CONVERTER).hashCode());
	}
	
	public void testToString(){
		assertEquals(
				"woolpack.el.CollectionTypeConvertEL@@[convertEL=woolpack.el.SimpleTypeConvertEL@@]", 
				new CollectionTypeConvertEL(ELConstants.SIMPLE_CONVERTER).toString().replaceAll("@[a-z0-9]+", "@@"));
	}
}
