/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import junit.framework.TestCase;

public class MapPropertyELFactoryTest extends TestCase {

	public void testConstructor(){
		try{
			new MapPropertyELFactory(null, ELConstants.PROPERTY_EL_FACTORY);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new MapPropertyELFactory(ELConstants.COLLECTION_CONVERTER, null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testEquals(){
		{
			final MapPropertyELFactory obj = new MapPropertyELFactory(ELConstants.SIMPLE_CONVERTER, ELConstants.PROPERTY_EL_FACTORY);
			assertTrue(obj.equals(obj));
		}
		assertEquals(new MapPropertyELFactory(ELConstants.SIMPLE_CONVERTER, ELConstants.PROPERTY_EL_FACTORY), new MapPropertyELFactory(ELConstants.SIMPLE_CONVERTER, ELConstants.PROPERTY_EL_FACTORY));
		assertFalse(new MapPropertyELFactory(ELConstants.SIMPLE_CONVERTER, ELConstants.PROPERTY_EL_FACTORY).equals(new MapPropertyELFactory(ELConstants.COLLECTION_CONVERTER, ELConstants.PROPERTY_EL_FACTORY)));
		assertFalse(new MapPropertyELFactory(ELConstants.SIMPLE_CONVERTER, ELConstants.PROPERTY_EL_FACTORY).equals(new MapPropertyELFactory(ELConstants.SIMPLE_CONVERTER, new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER))));
		assertFalse(new MapPropertyELFactory(ELConstants.SIMPLE_CONVERTER, ELConstants.PROPERTY_EL_FACTORY).equals(new Object()));
		assertFalse(new MapPropertyELFactory(ELConstants.SIMPLE_CONVERTER, ELConstants.PROPERTY_EL_FACTORY).equals(null));
	}
	
	public void testHashCode(){
		assertTrue(new MapPropertyELFactory(ELConstants.SIMPLE_CONVERTER, ELConstants.PROPERTY_EL_FACTORY).hashCode() == new MapPropertyELFactory(ELConstants.SIMPLE_CONVERTER, ELConstants.PROPERTY_EL_FACTORY).hashCode());
		assertTrue(new MapPropertyELFactory(ELConstants.SIMPLE_CONVERTER, ELConstants.PROPERTY_EL_FACTORY).hashCode() != new MapPropertyELFactory(ELConstants.COLLECTION_CONVERTER, ELConstants.PROPERTY_EL_FACTORY).hashCode());
		assertTrue(new MapPropertyELFactory(ELConstants.SIMPLE_CONVERTER, ELConstants.PROPERTY_EL_FACTORY).hashCode() != new MapPropertyELFactory(ELConstants.SIMPLE_CONVERTER, new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER)).hashCode());
	}
	
	public void testToString(){
		assertEquals(
				"woolpack.el.MapPropertyELFactory@@[convertEL=woolpack.el.SimpleTypeConvertEL@@,factory=woolpack.el.ReflectionPropertyELFactory@@[convertEL=woolpack.el.SimpleTypeConvertEL@@]]", 
				new MapPropertyELFactory(ELConstants.SIMPLE_CONVERTER, new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER)).toString().replaceAll("@[a-z0-9]+", "@@"));
	}
}
