/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import junit.framework.TestCase;

public class ToELTargetExceptionELTest extends TestCase {
	private final EL el0 = new ToELTargetExceptionEL(){
		@Override
		public Object execute(Object root, Object value) throws Exception {
			return null;
		}
	};
	
	private final EL el1 = new ToELTargetExceptionEL(){
		@Override
		public Object execute(Object root, Object value) throws Exception {
			throw new ELTargetRuntimeException(null);
		}
	};
	
	private final EL el2 = new ToELTargetExceptionEL(){
		@Override
		public Object execute(Object root, Object value) throws Exception {
			throw new Exception();
		}
	};
	
	public void testNormal(){
		el0.getValue(null);
		try{
			el1.getValue(null);
		}catch(final ELTargetRuntimeException e){
			assertNull(e.getCause());
		}
		try{
			el2.getValue(null);
		}catch(final ELTargetRuntimeException e){
			assertTrue(e.getCause() instanceof Exception);
		}
		
		el0.setValue(null, null);
		try{
			el1.setValue(null, null);
		}catch(final ELTargetRuntimeException e){
			assertNull(e.getCause());
		}
		try{
			el2.setValue(null, null);
		}catch(final ELTargetRuntimeException e){
			assertTrue(e.getCause() instanceof Exception);
		}
	}
}
