/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.util.Arrays;

import woolpack.TestUtils;
import junit.framework.TestCase;

public class SwitchBuilderTest extends TestCase {
	
	private void scenario(final SwitchBuilder<String,Integer> builder){
		assertEquals(builder, builder.put("a5", 5));
		try{
			builder.put("a5", 6);
			fail();
		}catch(final IllegalStateException expected){
		}
		assertEquals(builder, builder.put("a6", 6));
		final Switchable<String,Integer> switchable = builder.get(new Integer(3));
		
		assertEquals(new Integer(5), switchable.get("a5"));
		assertEquals(new Integer(6), switchable.get("a6"));
		assertEquals(new Integer(3), switchable.get("a7"));
		
		assertTrue(TestUtils.equals(Arrays.asList("a5", "a6"), switchable.keys()));
		assertEquals(new Integer(3), switchable.getDefault());
	}

	public void testNormal(){
		final SwitchBuilder<String,Integer> builder = new SwitchBuilder<String,Integer>();
		scenario(builder);
		scenario(builder);
		scenario(builder);
	}

	public void testNull(){
		final SwitchBuilder<String,Integer> builder = new SwitchBuilder<String,Integer>();
		try{
			builder.put(null, 5);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			builder.put(null, 6);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			builder.put("a1", null);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			builder.put("a1", null);
			fail();
		}catch(final NullPointerException expected){
		}

		assertEquals(builder, builder.put("a3", 3));
		final Switchable<String,Integer> switchable = builder.get(2);
		assertEquals(new Integer(2), switchable.get(null));
		assertEquals(new Integer(2), switchable.get("a1"));
		assertEquals(new Integer(3), switchable.get("a3"));
		assertTrue(TestUtils.equals(Arrays.asList("a3"), switchable.keys()));
		assertEquals(new Integer(2), switchable.getDefault());
	}
}
