/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

import junit.framework.TestCase;

public class MessageValidatorTest extends TestCase {

	public void testConstructor(){
		try{
			new MessageValidator(null);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new MessageValidator("");
			fail();
		}catch(final StringIndexOutOfBoundsException expected){
		}
	}
	
	public void testInterpret(){
		final ValidatorExpression expression = new MessageValidator("message0");
		final SimpleMessageCollector collector = new SimpleMessageCollector();
		final ValidatorContext context = new ValidatorContext();
		context.setCollectable(collector);
		
		context.setTmpKey("key0");
		assertFalse(expression.interpret(context));
		assertEquals(1, collector.getList().size());
		assertEquals("message0", collector.getList().get(0));
	}
	
	public void testAppendTo() throws IOException{
		final ValidatorExpression expression = new MessageValidator("message0");
		final StringBuilder sb = new StringBuilder();
		expression.appendTo(sb);
		assertEquals("new MessageValidator(\"message0\")", sb.toString());
	}
	
	public void testAddMessageTo(){
		final ValidatorExpression expression = new MessageValidator("message0");
		final Collection<String> expectedCollection = new ArrayList<String>();
		expression.addMessageTo(expectedCollection);
		assertEquals(1, expectedCollection.size());
		assertEquals("message0", expectedCollection.iterator().next());
	}
}
