/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el;

import java.lang.reflect.Array;
import java.util.Collection;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import woolpack.el.ELTargetRuntimeException;
import woolpack.el.GettingEL;
import woolpack.el.GettingELAdapter;
import woolpack.utils.UtilsConstants;

public class CollectionTypeConvertEL
extends GettingELAdapter {
    private final GettingEL convertEL;

    public CollectionTypeConvertEL(GettingEL convertEL) {
        convertEL.getClass();
        this.convertEL = convertEL;
    }

    public Object getValue(Object beforeValue, Class toType) throws ELTargetRuntimeException {
        if (Object.class.equals((Object)toType)) {
            return beforeValue;
        }
        Collection collection = UtilsConstants.toCollection(beforeValue);
        if (toType.isArray()) {
            Object afterArray = Array.newInstance(toType.getComponentType(), collection.size());
            int i = 0;
            for (Object before : collection) {
                Object after = this.convertEL.getValue(before, toType.getComponentType());
                Array.set(afterArray, i, after);
                ++i;
            }
            return afterArray;
        }
        if (Collection.class.isAssignableFrom(toType)) {
            return collection;
        }
        Object value = collection.iterator().next();
        if (value != null) {
            return this.convertEL.getValue(value, toType);
        }
        return value;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.convertEL).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CollectionTypeConvertEL)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CollectionTypeConvertEL o = (CollectionTypeConvertEL)obj;
        return new EqualsBuilder().append((Object)this.convertEL, (Object)o.convertEL).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("convertEL", (Object)this.convertEL).toString();
    }
}

