/*
 * Decompiled with CFR 0.152.
 */
package woolpack.utils;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import woolpack.utils.EmbeddingResolveable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddingResolver
implements EmbeddingResolveable {
    private final char abstractChar;
    private final char leftParenthesis;
    private final Pattern pattern;

    public EmbeddingResolver(char abstractChar, char leftParenthesis, char rightParenthesis) {
        this.abstractChar = abstractChar;
        this.leftParenthesis = leftParenthesis;
        this.pattern = Pattern.compile("(\\" + leftParenthesis + "([^\\}]+)\\" + rightParenthesis + ")");
    }

    public EmbeddingResolver() {
        this('#', '{', '}');
    }

    @Override
    public void resolve(Map<String, Object> map) {
        for (String key : map.keySet()) {
            this.getValueFromKey(map, key);
        }
    }

    private String resolveValueFromAbstractValue(Map<String, Object> map, String value) {
        Matcher matcher0 = this.pattern.matcher(value);
        if (!matcher0.find()) {
            return null;
        }
        Object objectValue = map.get(matcher0.group(2));
        if (objectValue == null || !(objectValue instanceof String)) {
            return null;
        }
        Matcher matcher1 = this.pattern.matcher((String)objectValue);
        StringBuffer sb = new StringBuffer();
        while (matcher0.find() && matcher1.find()) {
            String newValue = this.getValueFromKey(map, matcher0.group(2));
            if (newValue == null) {
                return null;
            }
            matcher1.appendReplacement(sb, newValue);
        }
        matcher1.appendTail(sb);
        return sb.toString();
    }

    private String resolveValueFromDirectValue(Map<String, Object> map, String value) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = this.pattern.matcher(value);
        while (matcher.find()) {
            String newValue = this.getValueFromKey(map, matcher.group(2));
            if (newValue == null) {
                return null;
            }
            matcher.appendReplacement(sb, newValue);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String resolveValue(Map<String, Object> map, String value) {
        if (value.charAt(0) == this.abstractChar) {
            return this.resolveValueFromAbstractValue(map, value);
        }
        if (value.indexOf(this.leftParenthesis) >= 0) {
            return this.resolveValueFromDirectValue(map, value);
        }
        return null;
    }

    @Override
    public String resolve(Map<String, Object> map, String value) {
        Object value1 = map.get(value);
        if (value1 == null) {
            value1 = this.resolveValue(map, value);
        }
        return (String)value1;
    }

    private String getValueFromKey(Map<String, Object> map, String key) {
        Object objectValue = map.get(key);
        if (objectValue == null || !(objectValue instanceof String)) {
            return null;
        }
        String value = (String)objectValue;
        if (value.indexOf(this.leftParenthesis) < 0) {
            return value;
        }
        String newValue = this.resolveValue(map, value);
        if (newValue == null) {
            return null;
        }
        map.put(key, newValue);
        return newValue;
    }
}

