/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.samples;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import woolpack.dom.DomExpression;
import woolpack.dom.FormatId;
import woolpack.dom.ResetId;
import woolpack.dom.Serial;
import woolpack.dom.XmlToNode;
import woolpack.samples.aa.AAServletTest;
import woolpack.samples.crud.SampleServletTest;
import woolpack.samples.frame.FrameServletTest;
import woolpack.samples.hello.HelloServletTest;
import woolpack.samples.locale.LocaleServletTest;
import woolpack.samples.transaction.TransactionServletTest;
import woolpack.text.RegExpFormat;
import woolpack.utils.InputStreamFactory;
import woolpack.utils.InputStreamReaderFactory;
import woolpack.utils.MapBuilder;

public class SamplesAllTests extends TestCase {

	public static final Map<String,String> attrNameMap = 
	MapBuilder.get(new HashMap<String,String>()).put("name", "value").put("id", null).get();
	
	public static DomExpression getFileToNode(final String regexp, final String replacement){
		return new ResetId(new Serial(
				new FormatId(new RegExpFormat(regexp, replacement)),
				new XmlToNode(new InputStreamReaderFactory(new InputStreamFactory(){
					public InputStream newInstance(final String id) throws IOException {
						return new FileInputStream(id);
					}}, "UTF-8"))));
	}

	public static Test suite() {
		TestSuite suite = new TestSuite();
		suite.addTest(new TestSuite(AAServletTest.class));
		suite.addTest(new TestSuite(SampleServletTest.class));
		suite.addTest(new TestSuite(FrameServletTest.class));
		suite.addTest(new TestSuite(HelloServletTest.class));
		suite.addTest(new TestSuite(LocaleServletTest.class));
		suite.addTest(new TestSuite(TransactionServletTest.class));
		return suite;
	}
}
