/*
 * Decompiled with CFR 0.152.
 */
package woolpack.crud;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import woolpack.crud.CrudFactory;
import woolpack.crud.Expression;
import woolpack.crud.ExpressionFactory2;
import woolpack.crud.ExpressionFactoryImpl;
import woolpack.crud.InputMapPointer;
import woolpack.crud.MarkableStringBuilder;
import woolpack.crud.PreparedStatementExecutor;
import woolpack.crud.Query;
import woolpack.crud.QueryFactory;
import woolpack.crud.QueryFactoryImpl;
import woolpack.crud.TableInfo;
import woolpack.crud.Updatable;
import woolpack.crud.UpdatableFactory;
import woolpack.crud.UpdatableFactoryCacheImpl;
import woolpack.crud.UpdatableFactoryImpl;
import woolpack.utils.CheckUtils;
import woolpack.utils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CrudConstants {
    private static final String COMMA = ", ";
    private static final String AND = " AND ";
    private static final String WHERE = " WHERE ";
    private static final String SET = " SET ";
    private static final String EQUAL = " = ";
    private static final String SPACE = "";
    private static final String HATENA = "?";
    private static final String GE = " >= ";
    private static final String LE = " <= ";
    public static final ExpressionFactory2 INSERT = new ExpressionFactory2(){

        @Override
        public Expression newInstance(TableInfo tableInfo, Map<String, List<Object>> map) {
            MarkableStringBuilder sb = new MarkableStringBuilder(new StringBuilder(), 2);
            sb.append("INSERT INTO ");
            sb.append(tableInfo.getName());
            sb.append('(');
            sb.mark(0);
            sb.append(") VALUES (");
            sb.mark(1);
            sb.append(')');
            ArrayList<InputMapPointer> inputMapPointerList = new ArrayList<InputMapPointer>();
            Set<String> columnSet = map.keySet();
            for (String column : tableInfo.getColumnCollection()) {
                String javaColumn = PropertyUtils.toJavaName(column);
                if (!columnSet.contains(javaColumn)) continue;
                inputMapPointerList.add(new InputMapPointer(javaColumn));
                sb.insert(0, CrudConstants.SPACE, CrudConstants.COMMA);
                sb.insert(0, column);
                sb.insert(1, CrudConstants.SPACE, CrudConstants.COMMA);
                sb.insert(1, CrudConstants.HATENA);
            }
            Expression expression = new Expression();
            expression.setQuery(sb.toString());
            expression.setInputMapPointerList(inputMapPointerList);
            return expression;
        }
    };
    public static final ExpressionFactory2 SELECT = new ExpressionFactory2(){

        @Override
        public Expression newInstance(TableInfo tableInfo, Map<String, List<Object>> map) {
            MarkableStringBuilder sb = new MarkableStringBuilder(new StringBuilder(), 2);
            sb.append("SELECT ");
            sb.mark(0);
            sb.append(" FROM ");
            sb.append(tableInfo.getName());
            sb.mark(1);
            ArrayList<InputMapPointer> inputMapPointerList = new ArrayList<InputMapPointer>();
            CrudConstants.buildSelectQueryBase(tableInfo, map, sb, inputMapPointerList, 0, 1);
            Expression expression = new Expression();
            expression.setQuery(sb.toString());
            expression.setInputMapPointerList(inputMapPointerList);
            return expression;
        }
    };
    public static final ExpressionFactory2 UPDATE = new ExpressionFactory2(){

        @Override
        public Expression newInstance(TableInfo tableInfo, Map<String, List<Object>> map) {
            MarkableStringBuilder sb = new MarkableStringBuilder(new StringBuilder(), 2);
            sb.append("UPDATE ");
            sb.append(tableInfo.getName());
            sb.mark(0);
            sb.append(" ");
            sb.mark(1);
            ArrayList<InputMapPointer> inputMapPointerList = new ArrayList<InputMapPointer>();
            Set<String> columnSet = map.keySet();
            int setPosition = 0;
            for (String column : tableInfo.getColumnCollection()) {
                String javaColumn = PropertyUtils.toJavaName(column);
                if (!columnSet.contains(javaColumn)) continue;
                if (tableInfo.getPrimaryKeyCollection().contains(column)) {
                    sb.insert(1, CrudConstants.WHERE, CrudConstants.AND);
                    sb.insert(1, column);
                    sb.insert(1, CrudConstants.EQUAL);
                    sb.insert(1, CrudConstants.HATENA);
                    inputMapPointerList.add(new InputMapPointer(javaColumn));
                    continue;
                }
                sb.insert(0, CrudConstants.SET, CrudConstants.COMMA);
                sb.insert(0, column);
                sb.insert(0, CrudConstants.EQUAL);
                sb.insert(0, CrudConstants.HATENA);
                inputMapPointerList.add(setPosition, new InputMapPointer(javaColumn));
                ++setPosition;
            }
            Expression expression = new Expression();
            expression.setQuery(sb.toString());
            expression.setInputMapPointerList(inputMapPointerList);
            return expression;
        }
    };
    public static final ExpressionFactory2 DELETE = new ExpressionFactory2(){

        @Override
        public Expression newInstance(TableInfo tableInfo, Map<String, List<Object>> map) {
            MarkableStringBuilder sb = new MarkableStringBuilder(new StringBuilder(), 1);
            sb.append("DELETE FROM ");
            sb.append(tableInfo.getName());
            sb.mark(0);
            ArrayList<InputMapPointer> inputMapPointerList = new ArrayList<InputMapPointer>();
            Set<String> columnSet = map.keySet();
            for (String column : tableInfo.getColumnCollection()) {
                String javaColumn = PropertyUtils.toJavaName(column);
                if (!columnSet.contains(javaColumn)) continue;
                inputMapPointerList.add(new InputMapPointer(javaColumn));
                sb.insert(0, CrudConstants.WHERE, CrudConstants.AND);
                sb.insert(0, column);
                sb.insert(0, CrudConstants.EQUAL);
                sb.insert(0, CrudConstants.HATENA);
            }
            Expression expression = new Expression();
            expression.setQuery(sb.toString());
            expression.setInputMapPointerList(inputMapPointerList);
            return expression;
        }
    };
    private static final Comparator<OrderInfo> ORDER_INFO_COMPARATOR = new Comparator<OrderInfo>(){

        @Override
        public int compare(OrderInfo o1, OrderInfo o2) {
            return o1.absoluteOrder - o2.absoluteOrder;
        }
    };

    private CrudConstants() {
    }

    public static void buildSelectQueryBase(TableInfo tableInfo, Map<String, List<Object>> map, MarkableStringBuilder sb, List<InputMapPointer> inputMapPointerList, int colIndex, int whereIndex) {
        for (String column : tableInfo.getColumnCollection()) {
            String javaColumn = PropertyUtils.toJavaName(column);
            List<Object> list = map.get(javaColumn);
            if (list != null) {
                if (list.size() == 2) {
                    sb.insert(whereIndex, WHERE, AND);
                    sb.insert(whereIndex, column);
                    sb.insert(whereIndex, GE);
                    sb.insert(whereIndex, HATENA);
                    inputMapPointerList.add(new InputMapPointer(javaColumn, 0));
                    sb.insert(whereIndex, WHERE, AND);
                    sb.insert(whereIndex, column);
                    sb.insert(whereIndex, LE);
                    sb.insert(whereIndex, HATENA);
                    inputMapPointerList.add(new InputMapPointer(javaColumn, 1));
                } else {
                    sb.insert(whereIndex, WHERE, AND);
                    sb.insert(whereIndex, column);
                    sb.insert(whereIndex, EQUAL);
                    sb.insert(whereIndex, HATENA);
                    inputMapPointerList.add(new InputMapPointer(javaColumn));
                }
            }
            sb.insert(colIndex, SPACE, COMMA);
            sb.insert(colIndex, column);
        }
    }

    public static void buildSelectQueryOrder(Map<String, List<Object>> map, MarkableStringBuilder sb, Pattern orderPattern, int orderIndex) {
        ArrayList<OrderInfo> orderList = new ArrayList<OrderInfo>();
        for (Map.Entry<String, List<Object>> entry : map.entrySet()) {
            Matcher m = orderPattern.matcher(entry.getKey());
            if (!m.matches()) continue;
            OrderInfo orderInfo = new OrderInfo();
            orderInfo.javaName = m.group(1);
            orderInfo.sqlName = PropertyUtils.toSQLName(orderInfo.javaName);
            orderInfo.order = Integer.valueOf(entry.getValue().get(0).toString());
            orderInfo.absoluteOrder = Math.abs(orderInfo.order);
            orderList.add(orderInfo);
        }
        Collections.sort(orderList, ORDER_INFO_COMPARATOR);
        for (OrderInfo orderInfo : orderList) {
            sb.insert(orderIndex, "ORDER BY ", COMMA);
            sb.insert(orderIndex, orderInfo.sqlName);
            sb.insert(orderIndex, orderInfo.order > 0 ? " ASC" : " DESC");
        }
    }

    public static ExpressionFactory2 getSelectExpressionFactory2(final Pattern orderPattern) {
        return new ExpressionFactory2(){

            @Override
            public Expression newInstance(TableInfo tableInfo, Map<String, List<Object>> map) {
                MarkableStringBuilder sb = new MarkableStringBuilder(new StringBuilder(), 3);
                sb.append("SELECT ");
                sb.mark(0);
                sb.append(" FROM ");
                sb.append(tableInfo.getName());
                sb.mark(1);
                sb.append(" ");
                sb.mark(2);
                ArrayList<InputMapPointer> inputMapPointerList = new ArrayList<InputMapPointer>();
                CrudConstants.buildSelectQueryBase(tableInfo, map, sb, inputMapPointerList, 0, 1);
                CrudConstants.buildSelectQueryOrder(map, sb, orderPattern, 2);
                Expression expression = new Expression();
                expression.setQuery(sb.toString());
                expression.setInputMapPointerList(inputMapPointerList);
                return expression;
            }
        };
    }

    public static List<TableInfo> getTableInfoList(DataSource dataSource) {
        ArrayList<TableInfo> list = new ArrayList<TableInfo>();
        try {
            Connection con = dataSource.getConnection();
            try {
                DatabaseMetaData metaData = con.getMetaData();
                CrudConstants.getTables(list, metaData);
                for (TableInfo tableInfo : list) {
                    CrudConstants.getColumns(tableInfo, metaData);
                    CrudConstants.getPrimaryKeys(tableInfo, metaData);
                }
            }
            finally {
                con.close();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        return list;
    }

    private static void getTables(List<TableInfo> list, DatabaseMetaData metaData) throws SQLException {
        ResultSet rs = metaData.getTables(null, "%", "%", null);
        try {
            while (rs.next()) {
                if ("SYSTEM TABLE".equals(rs.getString("TABLE_TYPE"))) continue;
                TableInfo tableInfo = new TableInfo();
                tableInfo.setCatalog(rs.getString("TABLE_CAT"));
                tableInfo.setSchema(rs.getString("TABLE_SCHEM"));
                tableInfo.setName(rs.getString("TABLE_NAME"));
                list.add(tableInfo);
            }
        }
        finally {
            rs.close();
        }
    }

    private static void getColumns(TableInfo tableInfo, DatabaseMetaData metaData) throws SQLException {
        ResultSet rs = metaData.getColumns(tableInfo.getCatalog(), tableInfo.getSchema(), tableInfo.getName(), "%");
        try {
            while (rs.next()) {
                tableInfo.getColumnCollection().add(rs.getString("COLUMN_NAME"));
            }
        }
        finally {
            rs.close();
        }
    }

    private static void getPrimaryKeys(TableInfo tableInfo, DatabaseMetaData metaData) throws SQLException {
        ResultSet rs = metaData.getPrimaryKeys(tableInfo.getCatalog(), tableInfo.getSchema(), tableInfo.getName());
        try {
            while (rs.next()) {
                tableInfo.getPrimaryKeyCollection().add(rs.getString("COLUMN_NAME"));
            }
        }
        finally {
            rs.close();
        }
    }

    public static Map<String, TableInfo> convertJavaNameTableInfoMap(List<TableInfo> list) {
        HashMap<String, TableInfo> map = new HashMap<String, TableInfo>();
        for (TableInfo info : list) {
            map.put(PropertyUtils.toJavaName(info.getName()), info);
        }
        return map;
    }

    public static CrudFactory getCrudFactory(DataSource dataSource, Pattern orderPattern, int maxRecode, String startPositionKey, String recodeCountKey) {
        CheckUtils.checkNotNull(dataSource);
        List<TableInfo> tableInfoList = CrudConstants.getTableInfoList(dataSource);
        Map<String, TableInfo> tableInfoMap = CrudConstants.convertJavaNameTableInfoMap(tableInfoList);
        PreparedStatementExecutor executable = new PreparedStatementExecutor(dataSource);
        return new CrudFactory(tableInfoMap, executable, orderPattern, maxRecode, startPositionKey, recodeCountKey){
            private final UpdatableFactory insertFactory;
            private final QueryFactory selectFactory;
            private final UpdatableFactory updateFactory;
            private final UpdatableFactory deleteFactory;
            {
                this.insertFactory = new UpdatableFactoryCacheImpl(new HashMap<Object, Updatable>(), new UpdatableFactoryImpl(new ExpressionFactoryImpl(map, INSERT), executable));
                this.selectFactory = new QueryFactoryImpl(new ExpressionFactoryImpl(map, CrudConstants.getSelectExpressionFactory2(pattern)), executable, n, string, string2);
                this.updateFactory = new UpdatableFactoryCacheImpl(new HashMap<Object, Updatable>(), new UpdatableFactoryImpl(new ExpressionFactoryImpl(map, UPDATE), executable));
                this.deleteFactory = new UpdatableFactoryCacheImpl(new HashMap<Object, Updatable>(), new UpdatableFactoryImpl(new ExpressionFactoryImpl(map, DELETE), executable));
            }

            @Override
            public Updatable newInsertUpdatable(String id, Map<String, List<Object>> map) {
                return this.insertFactory.newInstance(id, map);
            }

            @Override
            public Query newSelectQuery(String id, Map<String, List<Object>> map) {
                return this.selectFactory.newInstance(id, map);
            }

            @Override
            public Updatable newUpdateUpdatable(String id, Map<String, List<Object>> map) {
                return this.updateFactory.newInstance(id, map);
            }

            @Override
            public Updatable newDeleteUpdatable(String id, Map<String, List<Object>> map) {
                return this.deleteFactory.newInstance(id, map);
            }
        };
    }

    static class OrderInfo {
        String javaName;
        String sqlName;
        int absoluteOrder;
        int order;

        OrderInfo() {
        }
    }
}

