/*
 * Decompiled with CFR 0.152.
 */
package woolpack.crud;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import woolpack.crud.Executable;
import woolpack.crud.Expression;
import woolpack.crud.ExpressionFactory;
import woolpack.crud.Fetchable;
import woolpack.crud.Query;
import woolpack.crud.QueryFactory;
import woolpack.utils.CheckUtils;
import woolpack.utils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryFactoryImpl
implements QueryFactory {
    private final ExpressionFactory factory;
    private final Executable executable;
    private final int maxRecodes;
    private final String startPositionKey;
    private final String countKey;

    public QueryFactoryImpl(ExpressionFactory factory, Executable executable, int maxRecode, String startPositionKey, String recodeCountKey) {
        CheckUtils.checkNotNull(executable);
        CheckUtils.checkNotNull(factory);
        this.executable = executable;
        this.factory = factory;
        this.maxRecodes = maxRecode;
        this.startPositionKey = startPositionKey;
        this.countKey = recodeCountKey;
    }

    @Override
    public Query newInstance(String id, Map<String, List<Object>> map0) {
        final Expression expression = this.factory.newInstance(id, map0);
        return new Query(){
            private List<String> resultColumnNameList;

            @Override
            public List<Map<String, Object>> select(final Map<String, List<Object>> map1) {
                final ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                QueryFactoryImpl.this.executable.execute(expression, new Fetchable(){

                    public void fetch(Statement statement) {
                        int endPosition;
                        List value;
                        int startPosition = QueryFactoryImpl.this.startPositionKey == null ? 1 : ((value = (List)map1.get(QueryFactoryImpl.this.startPositionKey)) == null ? 1 : Integer.valueOf(value.get(0).toString()) + 1);
                        if (QueryFactoryImpl.this.countKey == null) {
                            endPosition = QueryFactoryImpl.this.maxRecodes;
                        } else {
                            List value2 = (List)map1.get(QueryFactoryImpl.this.countKey);
                            if (value2 == null) {
                                endPosition = QueryFactoryImpl.this.maxRecodes;
                            } else {
                                int tmpCount = Integer.valueOf(value2.get(0).toString());
                                endPosition = Math.min(QueryFactoryImpl.this.maxRecodes, startPosition + tmpCount - 1);
                            }
                        }
                        try {
                            ResultSet rs = statement.getResultSet();
                            try {
                                if (resultColumnNameList == null) {
                                    ResultSetMetaData md = rs.getMetaData();
                                    int size = md.getColumnCount();
                                    ArrayList<String> list2 = new ArrayList<String>(size);
                                    int i = 0;
                                    while (i < size) {
                                        list2.add(PropertyUtils.toJavaName(md.getColumnName(i + 1)));
                                        ++i;
                                    }
                                    resultColumnNameList = list2;
                                }
                                int count = 0;
                                while (rs.next()) {
                                    if (++count < startPosition) continue;
                                    HashMap<String, Object> bean = new HashMap<String, Object>();
                                    int i = 0;
                                    while (i < resultColumnNameList.size()) {
                                        bean.put((String)resultColumnNameList.get(i), rs.getObject(i + 1));
                                        ++i;
                                    }
                                    list.add(bean);
                                    if (endPosition > count) continue;
                                    break;
                                }
                            }
                            finally {
                                rs.close();
                            }
                        }
                        catch (SQLException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }, map1);
                return list;
            }
        };
    }
}

