/*
 * Decompiled with CFR 0.152.
 */
package woolpack.ee;

import java.util.List;
import java.util.Map;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.el.ArrayPathEL;
import woolpack.el.EL;
import woolpack.el.MapEL;
import woolpack.utils.CheckUtils;
import woolpack.utils.EmbeddingResolveable;
import woolpack.validator.SimpleMessageCollector;
import woolpack.validator.ValidatorConstants;
import woolpack.validator.ValidatorContext;
import woolpack.validator.ValidatorExpression;

public class ValidatorBuilder {
    public static final EL DEFALT_MESSAGES_EL = new ArrayPathEL(DomConstants.LOCAL_EL, (EL)new MapEL("woolpack.ee.MESSAGES"));
    private final EL messagesEL;
    private final boolean valueNotFoundIgnoreFlag;
    private final ValidatorExpression validatorExpression;

    public ValidatorBuilder(ValidatorExpression validatorExpression, EL messagesEL, boolean valueNotFoundIgnoreFlag) {
        CheckUtils.checkNotNull(validatorExpression);
        CheckUtils.checkNotNull(messagesEL);
        this.validatorExpression = validatorExpression;
        this.messagesEL = messagesEL;
        this.valueNotFoundIgnoreFlag = valueNotFoundIgnoreFlag;
    }

    public ValidatorBuilder(ValidatorExpression validatorExpression) {
        this(validatorExpression, DEFALT_MESSAGES_EL, false);
    }

    public EL getMessageEL() {
        return this.messagesEL;
    }

    public DomExpression getCheckExpression(final DomExpression trueExpression, final DomExpression falseExpression) {
        return new DomExpression(){

            public void interpret(DomContext domContext) {
                ValidatorContext validatorContext = new ValidatorContext();
                SimpleMessageCollector collector = new SimpleMessageCollector();
                validatorContext.setCollectable(collector);
                validatorContext.setId(domContext.getId());
                validatorContext.setInputMap(ValidatorConstants.convert(domContext.getInput()));
                Map tmpMap = domContext.getInput();
                try {
                    domContext.setInput(validatorContext.getInputMap());
                    if (ValidatorBuilder.this.validatorExpression.interpret(validatorContext)) {
                        trueExpression.interpret(domContext);
                    } else {
                        ValidatorBuilder.this.messagesEL.setValue(domContext, collector.getList());
                        falseExpression.interpret(domContext);
                    }
                }
                finally {
                    domContext.setInput(tmpMap);
                }
            }
        };
    }

    public DomExpression getReplaceExpression() {
        return this.getResolveEmbeddingExpression(new EmbeddingResolveable(){

            @Override
            public void resolve(Map<String, Object> map) {
            }

            @Override
            public String resolve(Map<String, Object> map, String value) {
                return (String)map.get(value);
            }
        });
    }

    public DomExpression getResolveEmbeddingExpression(final EmbeddingResolveable resolver) {
        CheckUtils.checkNotNull(resolver);
        return new DomExpression(){

            public void interpret(DomContext context) {
                List messages = (List)ValidatorBuilder.this.messagesEL.getValue(context);
                if (messages != null) {
                    int size = messages.size();
                    Map<String, Object> config = context.getConfig();
                    int i = 0;
                    while (i < size) {
                        String key = (String)messages.get(i);
                        String value = resolver.resolve(config, key);
                        if (value == null) {
                            if (!ValidatorBuilder.this.valueNotFoundIgnoreFlag) {
                                throw new IllegalStateException("not found.");
                            }
                        } else {
                            messages.set(i, value);
                        }
                        ++i;
                    }
                }
            }
        };
    }
}

