/*
 * Decompiled with CFR 0.152.
 */
package woolpack.html;

import org.w3c.dom.Element;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.dom.EvalAttrValueContains;
import woolpack.dom.If;
import woolpack.dom.RemoveAttr;
import woolpack.dom.UpdateAttrValue;
import woolpack.dom.XPath;
import woolpack.el.FixEL;
import woolpack.el.GettingEL;
import woolpack.html.UpdateToSelectedValue;
import woolpack.utils.CheckUtils;
import woolpack.utils.NodeFindable;
import woolpack.utils.NodeFindableFactory;

public class UpdateValue2
implements DomExpression {
    private static final String VALUE = "value";
    private static final String SELECTED = "selected";
    private static final String CHECKED = "checked";
    private static final GettingEL TRUE_EL = new FixEL("true");
    private final GettingEL valueEL;
    private final GettingEL mapEL;
    private final boolean selectFlag;
    private final NodeFindable xpathOption;

    public UpdateValue2(GettingEL valueEL, GettingEL mapEL, boolean selectFlag, NodeFindableFactory factory) {
        CheckUtils.checkNotNull(valueEL);
        this.valueEL = valueEL;
        this.mapEL = mapEL;
        this.selectFlag = selectFlag;
        this.xpathOption = factory.newInstance("//OPTION");
    }

    public UpdateValue2(GettingEL valueEL, GettingEL mapEL, NodeFindableFactory factory) {
        this(valueEL, mapEL, true, factory);
    }

    public UpdateValue2(GettingEL valueEL, NodeFindableFactory factory) {
        this(valueEL, null, true, factory);
    }

    private DomExpression getAttrValueExpression() {
        return new UpdateAttrValue(VALUE, this.valueEL);
    }

    private DomExpression getOptionExpression() {
        return this.selectFlag ? new If(new EvalAttrValueContains(VALUE, this.valueEL), new UpdateAttrValue(SELECTED, TRUE_EL), new RemoveAttr(SELECTED)) : this.getAttrValueExpression();
    }

    public void interpret(DomContext context) {
        Element e = (Element)context.getNode();
        String elementName = e.getNodeName();
        if ("OPTION".equals(elementName)) {
            this.getOptionExpression().interpret(context);
        } else if ("SELECT".equals(elementName)) {
            new XPath(this.xpathOption, this.getOptionExpression()).interpret(context);
        } else if ("INPUT".equals(elementName)) {
            String inputType = e.getAttribute("type");
            if ("file".equals(inputType) || "image".equals(inputType)) {
                return;
            }
            if (this.selectFlag) {
                if ("radio".equals(inputType) || "checkbox".equals(inputType)) {
                    new If(new EvalAttrValueContains(VALUE, this.valueEL), new UpdateAttrValue(CHECKED, TRUE_EL), new RemoveAttr(CHECKED)).interpret(context);
                } else {
                    this.getAttrValueExpression().interpret(context);
                }
            } else {
                this.getAttrValueExpression().interpret(context);
            }
        } else if ("BUTTON".equals(elementName)) {
            this.getAttrValueExpression().interpret(context);
        } else {
            new UpdateToSelectedValue(this.valueEL, this.mapEL).interpret(context);
        }
    }
}

