/*
 * Decompiled with CFR 0.152.
 */
package woolpack.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import woolpack.utils.CheckUtils;
import woolpack.utils.InputStreamFactory;
import woolpack.utils.ReaderFactory;

public class InputStreamReaderFactory
implements ReaderFactory {
    private final InputStreamFactory inputStreamFactory;
    private final String charset;

    public InputStreamReaderFactory(InputStreamFactory inputStreamFactory, String charset) {
        CheckUtils.checkNotNull(inputStreamFactory);
        this.inputStreamFactory = inputStreamFactory;
        this.charset = charset;
        if (charset != null && charset.length() > 0) {
            try {
                "a".getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public Reader newInstance(String id) throws IOException {
        InputStream stream = this.inputStreamFactory.newInstance(id);
        if (stream == null) {
            return null;
        }
        try {
            if (this.charset == null || this.charset.length() == 0) {
                return new BufferedReader(new InputStreamReader(stream));
            }
            return new BufferedReader(new InputStreamReader(stream, this.charset));
        }
        catch (IOException e) {
            stream.close();
            throw e;
        }
    }
}

