/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

// woolpackdoc.js

function convertAllDefault(){
var list = ["class", "className"];
convertAllByAttr(list, "link", convertLink);
convertAllByAttr(list, "linkDoc", convertLinkForDoc);
convertAllByAttr(list, "lineNumber", convertInsertLineNumber);
convertAllByAttr(list, "indexTable", convertInsertRowIndex);
convertAllByAttr(list, "indexTable", getConvertLineColor("bgcolor", ["#FFFFFF", "#CCFFFF"]));
convertAllByAttr(list, "renrakusaki", convertRenrakusaki);
flashIE();
}

function flashIE() {
if(navigator.userAgent.indexOf("MSIE") >= 0){
	var list = document.documentElement.getElementsByTagName("body");
	var s = list[0].innerHTML;
	list[0].innerHTML = s;
}
}

// 属性名と属性値を使用してノードを検索し、エレメントを引数として関数を作用させる(ie and firefox)。
function convertAllByAttr(attrNames, attrValue, targetFunction, element){
var innerElement = element;
if(innerElement == null){
	innerElement = document.documentElement;
}
if(innerElement.nodeType != 1){
	return;
}
for(var i=0; i<attrNames.length; i++){
	var value = innerElement.getAttribute(attrNames[i]);
	if(value == attrValue){
		targetFunction(innerElement);
	}
}
var list = innerElement.childNodes;
for(var i=0; i<list.length; i++){
	var child = list.item(i);
	convertAllByAttr(attrNames, attrValue, targetFunction, child);
}
}

// XPathを使用してノードを検索し、エレメントを引数として関数を作用させる(firefox only)。
function convertAll(xpath, targetFunction){
if(!(document.createNSResolver)){
	return;
}
var root = document.documentElement;
var resolver  = document.createNSResolver(root);
var expression= document.createExpression(xpath, resolver);
var result = expression.evaluate(root, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
for(var i=0; i<result.snapshotLength; i++){
	targetFunction(result.snapshotItem(i));
}
}

// エレメントの内部テキストエレメントがURLを表しているとしてhrefがURLでアンカー名がURLであるアンカーに変換する。
function convertLink(element){
var s = element.innerHTML;
element.innerHTML = "<a href=\"" + s + "\">" + s + "</a>";
}

// エレメントの内部テキストエレメントがURLを表しているとしてhrefがURLでアンカー名がファイル名であるアンカーに変換する。
function convertLinkForDoc(element){
var s = element.innerHTML;
var label = s.replace(new RegExp(".*/([^/]+)\.html$"), "$1");
element.innerHTML = "<a href=\"" + s + "\">" + label + "</a>";
}

// 行番号列を一列目に追加する。
function convertInsertRowIndex(element){
var trList = element.getElementsByTagName("tr");
for(var i = 0; i<trList.length; i++){
	var s = (i==0)?'#':'' + i;
	trList[i].insertCell(0).appendChild(document.createTextNode(s));
}
}

// 一行目の一列目をソースコードとみなして行数をカウントし、行番号の列を一列目に追加する。
function convertInsertLineNumber(element){
var trList = element.getElementsByTagName("tr");
if(trList.length < 1){
	return;
}
var count = 0;
{
	var tdList = element.getElementsByTagName("td");
	if(tdList.length < 1){
		return;
	}
	var brList = tdList[0].getElementsByTagName("br");
	count = brList.length;
}
var lineNumbers = "";
for(var i=0; i<count+1; i++){
	lineNumbers = lineNumbers + (i+1) + "<br/>";
}
var insertedCell = trList[0].insertCell(0);
insertedCell.innerHTML = lineNumbers;
insertedCell.setAttribute("valign", "top");
}

// 行毎に属性名に対する属性値を循環的に設定する関数を返す。
function getConvertLineColor(attrName, attrValueList) {
	return function(element){
		var trList = element.getElementsByTagName("tr");
		for(var i=0; i<trList.length; i++){
			trList[i].setAttribute(attrName, attrValueList[i%attrValueList.length]);
		}
	};
}

// 上下のセルが同一値の場合にセルを結合する。
function convertMargeCell(element){
	var trList = element.getElementsByTagName("tr");
	var length = trList.length;
	for(var i=length - 1; i>=0; i--){
		getConvertMargeCell(i)(element);
	}
}

// 対象列の上下のセルが同一値の場合にセルを結合する関数を返す。
function getConvertMargeCell(colIndex) {
	return function(element){
		var baseCell = null;
		var trList = element.getElementsByTagName("tr");
		for(var i=0; i<trList.length; i++){
			var tdList = trList[i].getElementsByTagName("td");
			if(tdList.length <= colIndex){
				continue;
			}
			if(baseCell == null){
				baseCell = tdList[colIndex];
				continue;
			}
			var cell = tdList[colIndex];
			if(baseCell.innerHTML == cell.innerHTML){
				var value = baseCell.getAttribute("rowspan");
				if(value == null){
					value = 1;
				}
				baseCell.setAttribute("rowspan", "" + (value + 1));
				cell.parentNode.removeChild(cell);
			}else{
				baseCell = cell;
			}
		}
	};
}

function convertRenrakusaki(element){
var s0 = element.innerHTML;
//s0 = s0.replace(/^<!\[CDATA\[/, "");
//s0 = s0.replace(/\]\]>$/, "");
var s2 = "";
for(var i=0; i<s0.length; i=i+2){
	s2 = s2 + s0.charAt(i);
}
element.innerHTML = s2;
}
