/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.adapter;

import javax.sql.DataSource;

import org.hsqldb.jdbc.jdbcDataSource;

/**
 * 静的メソッドの集まり。
 * テスト用。
 * 本クラスは HSQLDB のライブラリを使用する。
 * @author nakamura
 *
 */
public final class HSQLDBConstants {
	private HSQLDBConstants() {
	}
	
	/**
	 * HSQLDBのメモリDBへの{@link DataSource}を返す。
	 * @param name メモリDBの識別子。
	 * @return HSQLDBのメモリDBへの{@link DataSource}。
	 */
	public static DataSource getMemoryDataSource(final String name) {
		final jdbcDataSource dataSource = new jdbcDataSource();
		dataSource.setDatabase("jdbc:hsqldb:mem:" + name);
		dataSource.setUser("sa");
		dataSource.setPassword("");
		return dataSource;
	}
}
