/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.config;

import woolpack.utils.CheckUtils;

/**
 * {@link ConfigContext}の浅いコピーを委譲先に渡す{@link ConfigExpression}。
 * 適用しているパターン：Proxy。
 * 
 * @author nakamura
 * 
 */
public class CopyConfigContext implements ConfigExpression {
	private final ConfigExpression expression;

	/**
	 * コンストラクタ。
	 * 
	 * @param expression
	 *            委譲先。
	 * @throws NullPointerException
	 *             引数が null の場合。
	 */
	public CopyConfigContext(final ConfigExpression expression) {
		CheckUtils.checkNotNull(expression);
		this.expression = expression;
	}

	/**
	 * @throws NullPointerExcpeption
	 *             引数が null の場合。
	 */
	public void interpret(final ConfigContext context) {
		expression.interpret(context.copy());
	}
}
