/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.crud;

import java.sql.Statement;

/**
 * {@link Statement}に対する取得処理が可能であることを表す。
 * @author nakamura
 *
 */
public interface Fetchable {
	/**
	 * {@link Executable#execute(Expression, Fetchable, Map)}から呼び出される(called)。
	 * 実装では{@link Statement}に対する取得処理をおこなう。
	 * @param statement {@link Statement}。
	 */
	void fetch(Statement statement);
}
