/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.crud;

import java.util.List;
import java.util.Map;

import woolpack.utils.CheckUtils;

/**
 * 入力マップのポインタ。
 * @author nakamura
 *
 */
public class InputMapPointer {
	private final String key;
	private final int index;
	
	/**
	 * コンストラクタ。
	 * @param key キー。
	 */
	public InputMapPointer(final String key) {
		this(key, 0);
	}
	
	/**
	 * コンストラクタ。
	 * @param key キー。
	 * @param index インデックス。
	 */
	public InputMapPointer(final String key, final int index) {
		CheckUtils.checkNotNull(key);
		CheckUtils.checkNotNull(index);
		this.key = key;
		this.index = index;
	}

	/**
	 * 本ポインタが示す場所の値を返す。
	 * @param map 検索対象。
	 * @return 値。
	 */
	public Object get(final Map<String, List<Object>> map) {
		return map.get(key).get(index);
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + index;
		result = PRIME * result + ((key == null) ? 0 : key.hashCode());
		return result;
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final InputMapPointer other = (InputMapPointer) obj;
		if (index != other.index) {
			return false;
		}
		if (key == null) {
			if (other.key != null) {
				return false;
			}
		} else if (!key.equals(other.key)) {
			return false;
		}
		return true;
	}
}
