/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import woolpack.el.GettingEL;

/**
 * {@link GettingEL}を実行する{@link DomExpression}。 適用しているパターン：Adapter。
 * 
 * @author nakamura
 * 
 */
public class DoEL implements DomExpression {
	private final Evaluable<Object> eval;

	/**
	 * コンストラクタ。
	 * 
	 * @param resource
	 *            固定のオブジェクト。本クラスはこの引数の状態を変化させないが el がこの引数の状態を変化させる可能性がある。
	 * @param el
	 *            作用への参照。
	 * @throws NullPointerException
	 *             引数のいずれかが null の場合。
	 */
	public DoEL(final Object resource, final GettingEL el) {
		eval = new EvalEL(resource, el);
	}

	public void interpret(final DomContext context) {
		eval.eval(context);
	}
}
