/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import org.w3c.dom.Element;

import woolpack.utils.CheckUtils;

/**
 * DOM エレメントの属性を削除する{@link DomExpression}。
 * 
 * @author nakamura
 * 
 */
public class RemoveAttr implements DomExpression {
	private final String attrName;

	/**
	 * コンストラクタ。
	 * 
	 * @param attrName
	 *            削除対象の属性名。
	 * @throws NullPointerException
	 *             引数が null の場合。
	 * @throws StringIndexOutOfBoundsException
	 *             引数が空の場合。
	 */
	public RemoveAttr(final String attrName) {
		CheckUtils.checkNotEmpty(attrName);
		this.attrName = attrName;
	}

	/**
	 * @throws NullPointerException
	 *             引数または{@link DomContext#getNode()}が null の場合。
	 * @throws ClassCastException
	 *             {@link DomContext#getNode()}が{@link Element}でない場合。
	 */
	public void interpret(final DomContext context) {
		final Element element = (Element) context.getNode();
		element.removeAttribute(attrName);
	}
}
