/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import woolpack.el.convert.ConvertConstants;
import woolpack.el.convert.Convertable;

/**
 * 定数の集まり。
 * 
 * @author nakamura
 * 
 */
public final class ELConstants {

	/**
	 * null オブジェクト役の{@link EL}。
	 */
	public static final EL NULL = new AbstractEL() {
		@Override
		public Object getValue(final Object root, final Class toType) {
			return null;
		}

		@Override
		public void setValue(final Object root, final Object value) {
			// do nothing.
		}
	};

	/**
	 * プロパティにアクセスする{@link GettingEL}と{@link EL}のファクトリのデフォルト値。
	 */
	public static final PropertyELFactory PROPERTY_EL_FACTORY
	= getPropertyELFactory(ConvertConstants.COLLECTION_CONVERTER);

	private ELConstants() {
	} // カバレージがここを通過してはいけない

	/**
	 * プロパティにアクセスする{@link GettingEL}と{@link EL}のファクトリを返す。
	 * 
	 * @param convertable
	 *            型変換器。
	 * @return プロパティにアクセスする{@link GettingEL}と{@link EL}のファクトリ。
	 */
	public static PropertyELFactory getPropertyELFactory(
			final Convertable convertable) {
		return new MapPropertyELFactory(convertable,
				new CachePropertyELFactory(new ReflectionPropertyELFactory(
						convertable)));
	}
}
