/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.io.IOException;
import java.io.InputStream;

/**
 * id で委譲先を分岐する{@link InputStreamFactory}。 適用しているパターン：フィルタ。
 * 
 * @author nakamura
 * 
 */
public class BranchInputStreamFactory implements InputStreamFactory {
	private final Switchable<String, InputStreamFactory> switchable;

	/**
	 * コンストラクタ。
	 * 
	 * @param switchable
	 *            id と委譲先の{@link Switchable}。
	 */
	public BranchInputStreamFactory(
			final Switchable<String, InputStreamFactory> switchable) {
		CheckUtils.checkNotNull(switchable);
		this.switchable = switchable;
	}

	/**
	 * @throws NullPointerException
	 *             id に対する{@link InputStreamFactory}が存在しない場合。
	 */
	public InputStream newInstance(final String id) throws IOException {
		return switchable.get(id).newInstance(id);
	}
}
